@runBatch
def createDataSource(container, deployed):
    basicCommand = "data-source --profile=%s add --name=%s" % (container.profile, deployed.name)
    cmdBuilder = CommandBuilder(deployed, basicCommand)
    mapCommonDatasourceProperties(cmdBuilder)

    cmdBuilder.addIfNotBlank('newConnectionSql', "--new-connection-sql")
    cmdBuilder.addIfNotBlank('transactionIsolation', "--transaction-isolation")
    cmdBuilder.addIfNotBlank('connectionUrl', "--connection-url")
    cmdBuilder.add('useJta', "--jta")
    cmdBuilder.add('useCcm', "--use-ccm")

    logOutput("Creating datasource %s." % (deployed.name))
    executeCmd(cmdBuilder.cmd)

    logOutput("Setting connection properties.")
    connProps = deployed.getProperty("connectionProperties")
    connPropPath = "/subsystem=datasources/data-source=%s/connection-properties" % (deployed.name)
    connPropPath = prependProfilePath(connPropPath)

    for key in connProps.keySet():
        addConnPropCmd = "%s=%s:add(value=%s)" % (connPropPath, key, connProps[key])
        executeCmd(addConnPropCmd)

validateDataSource(deployed)
createDataSource(container, deployed)

# WFLY-3166: https://issues.jboss.org/browse/WFLY-3166
# version = getReleaseVersion()
# logOutput("Detected server version: %s." % version)
# if version and version[0:3] in ["8.0"]:
#     logOutput("Will NOT enable datasource.")
# else:
if True != isDataSourceEnabled(deployed.name):
    logOutput("Enabling datasource.")
    enableCmd = "/subsystem=datasources/data-source=%s:enable" %(deployed.name)
    enableCmd = prependProfilePath(enableCmd)
    executeCmd(enableCmd)

logOutput("Done.")



