from java.util import HashMap
from java.util import HashSet
from java.util import ArrayList
from java.io import FileInputStream

from com.bea.wli.sb.util import Refs
from com.bea.wli.config.customization import Customization
from com.bea.wli.sb.management.importexport import ALSBImportOperation

import sys, os

domainRuntime()

try:
	# Create session
	SessionMBean = None
	sessionName = createSessionName()
	SessionMBean = getSessionManagementMBean(sessionName)
	ALSBConfigurationMBean = findService(String("ALSBConfiguration.").concat(sessionName), "com.bea.wli.sb.management.configuration.ALSBConfigurationMBean")

	if len(deletedProjects) > 0:
		print "Delete projects not existing in the new package"
		deleteProjects(ALSBConfigurationMBean,deletedProjects)

	print "Importing OSB project %s." % deployed.name

	# Import project archive
	jarFiles=getFiles(deployed.file, deployed.configurationExtension)
	if len(jarFiles) == 0:
		jarFiles=getFiles(deployed.file, deployed.configurationExtension+".tmp")
		if len(jarFiles) == 0:
			print >> sys.stderr, "Jar files not found in %s:%s" % (deployed.file, os.listdir(deployed.file))
			raise

	importJar=jarFiles[0]
	print "Importing project archive %s." % (importJar)
	theBytes = readBinaryFile(importJar)


	ALSBConfigurationMBean.uploadJarFile(theBytes)

	alsbJarInfo = ALSBConfigurationMBean.getImportJarInfo()
	alsbImportPlan = alsbJarInfo.getDefaultImportPlan()
	alsbImportPlan.setPassphrase(deployed.passphrase)
	alsbImportPlan.setPreserveExistingEnvValues(true)

	# Prepare operation map
	operationMap=HashMap()
	operationMap = alsbImportPlan.getOperations()
	set = operationMap.entrySet()
	abort = false
	createdRef = ArrayList()
	for entry in set:
		ref = entry.getKey()
		op = entry.getValue()
		type = ref.getTypeId
		if type == Refs.SERVICE_ACCOUNT_TYPE or type == Refs.SERVICE_PROVIDER_TYPE:
			if op.getOperation() == ALSBImportOperation.Operation.Create:
				print "Unable to import a service account or a service provider on a target system", ref
				abort = true
		elif op.getOperation() == ALSBImportOperation.Operation.Create:
			createdRef.add(ref)
	if abort == true :
		print >> sys.stderr, 'This jar must be imported manually to resolve the service account and service provider dependencies'
		SessionMBean.discardSession(sessionName)
		raise
	print createdRef
	printOpMap(operationMap)

	# Complete import according to import plan
	importResult = ALSBConfigurationMBean.importUploaded(alsbImportPlan)

	if importResult.getImportDiagnostics() <> None or importResult.getImportDiagnostics() <> "":
		printDiagMap(importResult.getImportDiagnostics())

	if importResult.getFailed().isEmpty() == false:
		print >> sys.stderr, 'One or more resources could not be imported properly'
		raise


	# Execute customization file
	xmlFiles=getFiles(deployed.file, deployed.customizationFileExtension)
	for customFile in getFiles(deployed.file, deployed.customizationFileExtension):
		print 'Loading customization File', customFile
		print 'Customization applied to the created resources only', createdRef
		iStream = FileInputStream(customFile)
		customizationList = Customization.fromXML(iStream)
		filteredCustomizationList = ArrayList()
		setRef = HashSet(createdRef)

		# apply a filter to all the customizations to narrow the target to the created resources
		for customization in customizationList:
			printTargets(customization)
			newcustomization = customization.clone(setRef)
			filteredCustomizationList.add(newcustomization)

		print "Processing customizations."
		ALSBConfigurationMBean.customize(filteredCustomizationList)

	# Activate session
	print "Activating session %s " % (sessionName)
	activationText="Import %s into %s" % (deployed.name, deployed.container.name)
	SessionMBean.activateSession(sessionName, activationText)

	print "Project successfully imported."
except:
	print >> sys.stderr, "Unexpected error:", sys.exc_info()[0]
	if SessionMBean != None:
		print "Discarding session %s" % (sessionName)
		SessionMBean.discardSession(sessionName)
	raise

