package com.xebialabs.deployit.plugin.osb.deployed;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;

@SuppressWarnings("serial")
@Placeholders
@Metadata(virtual = true)
public class ExtensibleDeployedArtifact<D extends DeployableArtifact> extends com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact<D> {

    private Set<String> deletedProjects = Sets.newHashSet();

    @Create
    @Modify
    @Override
    public void startApplication(DeploymentPlanningContext result) {
        // Don't add steps
    }

    @Modify
    @Override
    public void stopApplicationForModifedArtifact(DeploymentPlanningContext result, Delta delta) {
        // Don't add steps
    }

    @Destroy
    @Override
    public void stopApplication(DeploymentPlanningContext result) {
        // Don't add steps
    }

    @Override
    public void modifyArtifact(DeploymentPlanningContext result, Delta delta) {
        // Don't add steps
    }

    @Modify
    public void modifyConfiguration(DeploymentPlanningContext result, Delta delta) {
        Set<String> previousProjects = delta.getPrevious().getProperty("projectNames");
        Set<String> currentProjects = delta.getDeployed().getProperty("projectNames");

        final int order = (Integer) getProperty("modifyOrder");
        deletedProjects = Sets.difference(previousProjects,currentProjects);
        addStep(result, order, (String) getProperty("modifyScript"), (String) getProperty("modifyVerb"));
    }

    @Override
    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        Map<String, Object> pythonVars = Maps.newHashMap(super.getPythonVars(deployedApplication));
        pythonVars.put("deletedProjects", deletedProjects);
        return pythonVars;
    }

}
