package com.xebialabs.deployit.plugin.osb.container;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.INFRASTRUCTURE;
import static java.util.Collections.emptySet;

@SuppressWarnings("serial")
@Metadata(root = INFRASTRUCTURE,  description="OSB domain on the WebLogic server", inspectable = true)
public class Domain extends com.xebialabs.deployit.plugin.wls.container.Domain implements WlsContainer {

    @Property(required = true, defaultValue = "osb/runtime", hidden = true)
    private String pythonRuntimePath;

    @Property(required = true, defaultValue = "osb", hidden = true, description = "Path containing the wlst templates: wlst.sh.ftl (Unix) and wlst.cmd.ftl (Windows)")
    private String wlstTemplatePath;

    @InspectionProperty(required = true)
    @Property(required = true, description="OSB Home directory", category="Oracle Service Bus")
    private String osbHome;

    @Override
    public CmdLine getScriptCommandLine(OverthereFile script) {
        final CmdLine cmdLine = getScriptCommandLineForTemplate(script, wlstTemplatePath);
        uploadPasswordFile(script, wlstTemplatePath);
        return cmdLine;
    }

    @Override
    public String getRuntimePath() {
        return getProperty("pythonRuntimePath");
    }

    @Override
    public com.xebialabs.deployit.plugin.wls.container.Domain getDomain() {
        return this;
    }

    @Override
    public String getObjectName() {
        return "";
    }

    @Override
    public Set<Host> getHosts() {
        return newHashSet(getHost());
    }

    @Override
    public Set<Server> getServers() {
        return emptySet();
    }

    @Override
    public int getStopOrder() {
        return 25;
    }

    @Override
    public int getStartOrder() {
        return 75;
    }
}
