package com.xebialabs.deployit.plugin.policy

import java.io.FileOutputStream
import java.nio.file.{Files, Paths}
import java.util
import java.util.zip.{ZipEntry, ZipOutputStream}

import com.thoughtworks.xstream.XStream
import com.xebialabs.deployit.core.rest.xml.{StepStateWriter, ArchivedTaskWriter}
import com.xebialabs.deployit.task.archive.ArchivedTask

import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter
import org.python.core.PyInstance
import scala.collection.convert.wrapAll._

object TaskExporter {
  def export(tasks: util.Collection[PyInstance], archivePath: String) {
    val writer = new XStream(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER)
    writer.registerConverter(new ArchivedTaskWriter())
    writer.registerConverter(new StepStateWriter())
    writer.aliasType("task", classOf[ArchivedTask])

    if (archivePath == null) {
      throw new Exception("Property 'archivePath' not defined, please define a valid path for the export.")
    }

    val archivedTaskPath = Paths.get(archivePath)
    val archiveDir = archivedTaskPath.getParent

    if (!Files.exists(archiveDir)) {
      Files.createDirectories(archiveDir)
    }

    val zip = new ZipOutputStream(new FileOutputStream(archivedTaskPath.toFile))
    try {
      tasks.map(_.__getattr__("_delegate").__tojava__(classOf[ArchivedTask]).asInstanceOf[ArchivedTask]).foreach { task =>
        val taskFileName = s"${task.getStartDate.toString("yyyy/MM/dd")}/${task.getId}.xml"
        zip.putNextEntry(new ZipEntry(taskFileName))
        writer.toXML(task, zip)
        zip.closeEntry()
      }
    } finally {
      zip.close()
    }
  }
}
