# Require PowerShell version 2.0
#Requires -Version 2.0

# Set screen size

$pshost = get-host
$pswindow = $pshost.ui.rawui
$newsize = $pswindow.buffersize
$newsize.height = 3000
$newsize.width = 1024
$pswindow.buffersize = $newsize

# Discovery functions

Add-Type -AssemblyName System.Web

Function quote_plus($val) {
   [System.Web.HttpUtility]::UrlEncode($val)
}

Function discovered($id, $type) {
     Write-Output "DISCOVERED-ITEM:$(quote_plus($id)):$(quote_plus($type))"
}

Function inspectedProperty($id, $name, $value) {
    if ($value -is [array]) {
        foreach ($v in $value) {
           Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($v))"
        }
    } elseif ($value -is [hashtable]) {
        foreach ($k in $value.Keys) {
            $v = $value[$k]
            if ($v -eq $null)
               { $v = "" }
            Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($k)):$(quote_plus($v))"
        }
    } else {
        Write-Output "INSPECTED-PROPERTY:$(quote_plus($id)):$(quote_plus($name)):$(quote_plus($value))"
    }
}

Function inspected($name, $value) {
    inspectedProperty('this', $name, $value)
}

Function inspectedItem($id) {
    Write-Output "INSPECTED-ITEM:$(quote_plus($id))"
}

Function Get-IniContent ($filePath)
{
    Write-Output "Reading variables from .ini file: $($filePath)"
    $ini = @{}
    switch -regex -file $filePath
    {
        "^\[(.+)\]" # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        "^(;.*)$" # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = "Comment" + $CommentCount
            $ini[$section][$name] = $value
        }
        "(.+?)\s*=(.*)" # Key
        {
            $name, $value = $matches[1..2]
            $ini[$section][$name] = $value
        }
    }
    return $ini
}

Function As-Boolean ($value)
{
    try {
        $result = [System.Convert]::ToBoolean($value)
    } catch [FormatException] {
        $result = $false
    }
    return $result
}

Function As-Int ($value)
{
    return [convert]::ToInt32($value, 10)
}

Function As-Long ($value)
{
    return [convert]::ToInt64($value, 10)   
}
