/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.plugin.powershell.BasePowershellVarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PowerShellIniConverter
extends BasePowershellVarsConverter {
    private final Map<String, List<String>> iniSections = new HashMap<String, List<String>>();
    private final String iniFilePath;

    PowerShellIniConverter(OverthereConnection connection, Map<String, Object> powershellVars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts, String iniFilePath) {
        super(connection, powershellVars, maskPasswords, exposePasswordPropertiesOnHosts);
        this.iniFilePath = iniFilePath;
    }

    protected void setNullVariable(String variableName) {
        this.add("$" + variableName + " = $null");
    }

    protected void setBooleanVariable(String variableName, boolean variableValue) {
        this.addSection("Variables", variableName, String.valueOf(variableValue));
        this.add("$" + variableName + " = As-Boolean($ini.Variables.'" + variableName + "')");
    }

    protected void setIntegerVariable(String variableName, int variableValue) {
        this.addSection("Variables", variableName, String.valueOf(variableValue));
        this.add("$" + variableName + " = As-Int($ini.Variables.'" + variableName + "')");
    }

    protected void setLongVariable(String variableName, long variableValue) {
        this.addSection("Variables", variableName, String.valueOf(variableValue));
        this.add("$" + variableName + " = As-Long($ini.Variables.'" + variableName + "')");
    }

    protected void setStringVariable(String variableName, String variableValue) {
        this.addSection("Variables", variableName, variableValue);
        this.add("$" + variableName + " = $ini.Variables.'" + variableName + "'");
    }

    protected void setCollectionOfStringsVariable(String variableName, Collection<?> variableValue) {
        int i = 0;
        ArrayList<CallSite> variableNames = new ArrayList<CallSite>();
        for (Object o : variableValue) {
            String variable = variableName + "_" + i++;
            this.addSection("Variables", variable, o.toString());
            variableNames.add((CallSite)((Object)("$ini.Variables.'" + variable + "'")));
        }
        this.add("$" + variableName + " = @(" + Joiner.on((String)", ").join(variableNames) + ")");
    }

    private void addSection(String section, String name, String value) {
        List values = this.iniSections.putIfAbsent(section, new ArrayList());
        values.add(name + "=" + value);
    }

    protected void startCreateObject(String objectName) {
        this.iniSections.put(objectName, new ArrayList());
        this.add("$" + objectName + " = New-Object Object");
        this.add("$__" + objectName + " = $ini." + objectName);
    }

    protected void setBooleanProperty(String objectName, String propertyName, boolean propertyValue) {
        this.iniSections.get(objectName).add(propertyName + "=" + String.valueOf(propertyValue));
        this.add("$" + propertyName + "AsBool = As-Boolean($__" + objectName + "." + propertyName + ")");
        this.setNoteProperty(objectName, propertyName, "$" + propertyName + "AsBool");
    }

    protected void setIntegerProperty(String objectName, String propertyName, int propertyValue) {
        this.iniSections.get(objectName).add(propertyName + "=" + String.valueOf(propertyValue));
        this.add("$" + propertyName + "AsInt = As-Int($__" + objectName + "." + propertyName + ")");
        this.setNoteProperty(objectName, propertyName, "$" + propertyName + "AsInt");
    }

    protected void setStringProperty(String objectName, String propertyName, String propertyValue) {
        this.iniSections.get(objectName).add(propertyName + "=" + propertyValue);
        this.setNoteProperty(objectName, propertyName, "$__" + objectName + "." + propertyName);
    }

    protected void setPasswordProperty(String objectName, String propertyName, String propertyValue) {
        this.iniSections.get(objectName).add(propertyName + "=" + Base64.encodeBase64String((byte[])propertyValue.getBytes(StandardCharsets.UTF_16)));
        this.setNoteProperty(objectName, propertyName, "([System.Text.Encoding]::Unicode.GetString([System.Convert]::FromBase64String($__" + objectName + "." + propertyName + ")))");
    }

    protected void setCollectionOfStringsProperty(String objectName, String propertyName, Collection<?> propertyValue) {
        int i = 0;
        ArrayList<CallSite> variableNames = new ArrayList<CallSite>();
        for (Object o : propertyValue) {
            String variableName = propertyName + "_" + i++;
            this.addSection(objectName, variableName, o.toString());
            variableNames.add((CallSite)((Object)("$__" + objectName + "." + variableName)));
        }
        this.setNoteProperty(objectName, propertyName, "@(" + Joiner.on((String)", ").join(variableNames) + ")");
    }

    protected void setMapOfStringToStringReferencesProperty(String objectName, String propertyName, Map<String, String> propertyValue) {
        ArrayList<CallSite> contents = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : propertyValue.entrySet()) {
            String variableName = propertyName + "_" + entry.getKey();
            if (entry.getValue() != null) {
                this.addSection(objectName, variableName, entry.getValue());
                contents.add((CallSite)((Object)(entry.getKey() + " = $__" + objectName + "." + variableName)));
                continue;
            }
            contents.add((CallSite)((Object)(entry.getKey() + " = $null")));
        }
        this.setNoteProperty(objectName, propertyName, "@{" + Joiner.on((String)"; ").join(contents) + "}");
    }

    public List<String> convert() {
        this.add("$ini = Get-IniContent('" + this.iniFilePath + "')");
        List lines = super.convert();
        return lines;
    }

    public List<String> getConvertedIniContents() {
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.iniSections.entrySet()) {
            lines.add("[" + entry.getKey() + "]");
            lines.addAll((Collection<String>)entry.getValue());
            lines.add("");
        }
        return lines;
    }
}

