package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class BaseExtensiblePowerShellDeployed<D extends Deployable> extends BasePowerShellDeployed<D, PowerShellContainer> {

	@Property(hidden = true, required = false, description = "PowerShell script invoked to deploy an artifact or a resource on Windows")
	private String createScript;

	@Property(hidden = true, defaultValue = "Create", description="The word is used to prefix a step description for the create operation.")
	private String createVerb;

	@Property(hidden = true, defaultValue = "60", description = "The order in which a create step will be executed.")
	private int createOrder;

	@Property(hidden = true, required = false, description = "PowerShell script invoked to upgrade an artifact or a resource on Windows")
	private String modifyScript;

	@Property(hidden = true, defaultValue = "Modify",description="The word is used to prefix a step description for the modify operation.")
	private String modifyVerb;

	@Property(hidden = true, defaultValue = "60", description = "The order in which a modify step will be executed.")
	private int modifyOrder;

	@Property(hidden = true, required = false, description = "PowerShell script invoked to undeploy an artifact or a resource on Windows")
	private String destroyScript;

	@Property(hidden = true, defaultValue = "Destroy", description="The word is used to prefix a step description for the destroy operation.")
	private String destroyVerb;

	@Property(hidden = true, defaultValue = "40", description = "The order in which a destroy step will be executed.")
	private int destroyOrder;

	@Create
	public void create(DeploymentPlanningContext ctx) {
		addStep(ctx, createOrder, createScript, createVerb, true);
	}

    @Modify
	public void modify(DeploymentPlanningContext ctx, Delta delta) {
		if (!addStep(ctx, modifyOrder, modifyScript, modifyVerb, true)) {
			BaseExtensiblePowerShellDeployed<?> previous = (BaseExtensiblePowerShellDeployed<?>) delta.getPrevious();
			previous.destroy(ctx);

			BaseExtensiblePowerShellDeployed<?> current = (BaseExtensiblePowerShellDeployed<?>) delta.getDeployed();
			current.create(ctx);
		}
	}

	@Destroy
	public void destroy(DeploymentPlanningContext ctx) {
		addStep(ctx, destroyOrder, destroyScript, destroyVerb, false);
	}

}
