package com.xebialabs.deployit.plugin.powershell;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.remoting.inspection.InspectionProtocolContext;

@SuppressWarnings("serial")
public class PowerShellInspectionStep extends PowerShellStep {

    protected ConfigurationItem inspectedItem;

    public PowerShellInspectionStep(HostContainer container, Deployed<?, ?> deployed, String scriptPath, Map<String, Object> powershellVars, String description) {
        super(container, deployed, scriptPath, powershellVars, 50, description);
        inspectedItem = container;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        InspectionProtocolContext protocolContext = new InspectionProtocolContext(inspectedItem, ctx);
        StepExitCode result = doExecute(protocolContext);

        if (protocolContext.isInspectionFailed()) {
            ctx.logError("Inspection failed, check the logs");
            result = StepExitCode.FAIL;
        }

        return result;
    }
}
