package com.xebialabs.deployit.plugin.remoting.preview;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.BaseOverthereFile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class PreviewOverthereFile extends BaseOverthereFile<PreviewOverthereConnection> implements OverthereFile {

    private PreviewOverthereConnection connection;

    private String path;

    PreviewOverthereFile(PreviewOverthereConnection connection, String path) {
        this.connection = connection;
        this.path = path;
    }

    @Override
    public PreviewOverthereConnection getConnection() {
        return connection;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public String getName() {
        String fileSep = connection.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0) {
            return path;
        } else {
            return path.substring(lastFileSepPos + 1);
        }
    }

    @Override
    public OverthereFile getParentFile() {
        String fileSep = connection.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0 || path.equals(fileSep)) {
            return null;
        } else if (lastFileSepPos == 0) {
            // the parent of something in the root directory is the root directory itself.
            return connection.getFile(fileSep);
        } else {
            return connection.getFile(path.substring(0, lastFileSepPos));
        }
    }

    @Override
    public OverthereFile getFile(String child) {
        String fileSep = connection.getHostOperatingSystem().getFileSeparator();
        return new PreviewOverthereFile(connection, path + fileSep + child);
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0;
    }

    @Override
    public long length() {
        return 0;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public OutputStream getOutputStream() {
        return new DevNull();
    }

    @Override
    public void setExecutable(boolean executable) {
    }

    @Override
    public void delete() {
    }

    @Override
    public void deleteRecursively() {
    }

    @Override
    public List<OverthereFile> listFiles() {
        return newArrayList();
    }

    @Override
    public void mkdir() {
    }

    @Override
    public void mkdirs() {
    }

    @Override
    public void renameTo(OverthereFile dest) {
    }

    @Override
    public String toString() {
        return PreviewOverthereConnection.PREVIEW_PROTOCOL + ":" + path;
    }

    @Override
    protected void shortCircuitCopyFrom(OverthereFile source) {
    }

    @Override
    protected void copyFrom(OverthereFile source) {
    }
}
