package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.overthere.cifs.CifsConnectionType;

public class UsernameValidation {

    public static class Validator extends BaseValidator {

        protected void validate(Host value, ValidationContext context, String protocol) {
            CifsConnectionType connectionType = value.getProperty("connectionType");
            String username = value.getProperty("username");
            switch (connectionType) {
                case TELNET:
                    if (username.contains("@")) {
                        context.error("%s/Telnet host [%s] cannot have a new-style domain username (%s).", protocol, value.getId(), username);
                    }
                    break;
                case WINRM_INTERNAL:
                    if (username.contains("\\")) {
                        context.error("%s/%s host [%s] cannot have an old-style domain username (%s).", protocol, connectionType, value.getId(), username);
                    }
                    break;
                case WINRM_NATIVE:
                    // no-op
                    break;
            }
        }

    }

}