package com.xebialabs.xldeploy.authentication.oidc.conf

import org.springframework.security.core.GrantedAuthority
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority

import java.util

object DeployOidcGrantedAuthoritiesMapper {
  def grantedAuthoritiesMapper: GrantedAuthoritiesMapper = (authorities: util.Collection[_ <: GrantedAuthority]) => {
    val mappedAuthorities: util.Set[GrantedAuthority] = new util.HashSet[GrantedAuthority]
    authorities.forEach((authority: GrantedAuthority) => {
      var mappedAuthority: GrantedAuthority = null
      if (authority.isInstanceOf[OidcUserAuthority]) {
        val userAuthority: OidcUserAuthority = authority.asInstanceOf[OidcUserAuthority]
        mappedAuthority = new OidcUserAuthority("ROLE_USER", userAuthority.getIdToken, userAuthority.getUserInfo)
      }
      else if (authority.isInstanceOf[OAuth2UserAuthority]) {
        val userAuthority: OAuth2UserAuthority = authority.asInstanceOf[OAuth2UserAuthority]
        mappedAuthority = new OAuth2UserAuthority("ROLE_USER", userAuthority.getAttributes)
      }
      else mappedAuthority = authority
      mappedAuthorities.add(mappedAuthority)

    })
    mappedAuthorities
  }
}