/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.plugin.stitch.service.engine.context;

import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.xlplatform.documentation.PublicApi;

/**
 * DeploymentContext represents context that is available during deployment
 * and stitch transformation.
 */
@PublicApi
public interface DeploymentContext {

  /**
   * Returns deployed for deployment.
   *
   * @return deployed that is being deployed.
   */
  Deployed<?, ?> getDeployed();

  /**
   * Returns deployed from previous deployment.
   *
   * @return deployed that was deployed before this deployment.
   */
  Deployed<?, ?> getPreviousDeployed();

  /**
   * Returns current deployed.
   *
   * @return deployed that is currently being deployed
   *     (may be different than getDeployed for rollback action).
   */
  Deployed<?, ?> getCurrentDeployed();

  /**
   * Returns deployed application for deployment.
   *
   * @return deployed application that is being deployed.
   */
  DeployedApplication getDeployedApplication();

  /**
   * Returns previously deployed application.
   *
   * @return deployed application that was deployed in previous deployment.
   */
  DeployedApplication getPreviousDeployedApplication();

  /**
   * Returns current deployed application.
   *
   * @return deployed application that is currently being deployed
   *     (may be different than getDeployedApplication for rollback action).
   */
  DeployedApplication getCurrentDeployedApplication();
}
