/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * The object container for transformation input and output documents.
 */
@PublicApiRef
public class InvocationOutput extends AbstractDto {

  private String input;
  private String output;

  public InvocationOutput() {
  }

  public InvocationOutput(String input, String output) {
    this.input = input;
    this.output = output;
  }

  /**
   * Returns input object as string.
   *
   * @return The input document for transformation.
   */
  public String getInput() {
    return input;
  }

  /**
   * Sets input object as string.
   *
   * @param input The input document for transformation.
   */
  public void setInput(String input) {
    this.input = input;
  }

  /**
   * Returns output object as string.
   *
   * @return The output document from transformation.
   */
  public String getOutput() {
    return output;
  }

  /**
   * Sets output object as string.
   *
   * @param output The output document from transformation.
   */
  public void setOutput(String output) {
    this.output = output;
  }
}
