/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.plugin.stitch.model;

import com.xebialabs.xlplatform.documentation.PublicApi;

import java.util.Optional;

/**
 * StitchParameter represents one parameter that processor can have.
 */
@PublicApi
public interface StitchParameter {

  /**
   * Returns parameters name.
   *
   * @return name of a parameter as {@link String}.
   */
  String getName();

  /**
   * Returns parameters value.
   *
   * @return parameter value as {@link String}.
   */
  String getValue();

  /**
   * Returns parameters value from external file.
   *
   * @return associated file content if value is stored in external file (not inline).
   */
  Optional<String> getFileContent();
}
