/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.format.input.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.documentation.PublicApi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

/**
 * Input adapter responsible for transforming desired input format to {@link JsonNode}.
 */
@PublicApi
public interface InputAdapter {

    /**
     * Gets all file formats that are supported with this consumer.
     *
     * @return set of file formats
     */
    Set<String> getFileFormats();

    /**
     * Converts input stream to {@link JsonNode}
     * @param input input to be converted
     * @return resulting {@link JsonNode}
     * @throws IOException when conversion fails
     */
    JsonNode convert(InputStream input) throws IOException;
}
