/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.tests.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class LocalHttpTesterStep
extends GenericBaseStep {
    private String url;
    private String expectedResponseText;
    private boolean showPageInConsole;
    private int startDelay;
    private int noOfRetries;
    private int retryWaitInterval;

    public LocalHttpTesterStep(int order, String description, Container container, String url, String expectedResponseText, int startDeplay, int noOfRetries, int retryWaitInterval, boolean showPageInConsole) {
        super(order, description, container);
        this.url = url;
        this.expectedResponseText = expectedResponseText;
        this.startDelay = startDeplay;
        this.noOfRetries = noOfRetries;
        this.retryWaitInterval = retryWaitInterval;
        this.showPageInConsole = showPageInConsole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute() throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(this.url);
        try {
            this.getCtx().logOutput("Waiting for " + this.startDelay + " secs before executing step");
            this.waitFor(this.startDelay);
            Step.Result result = this.verifyContentWithRetryAttempts(this.getCtx(), client, method);
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            method.releaseConnection();
        }
        return Step.Result.Fail;
    }

    private Step.Result verifyContentWithRetryAttempts(DeploymentExecutionContext ctx, HttpClient client, GetMethod method) throws InterruptedException {
        for (int i = 0; i < this.noOfRetries; ++i) {
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    return this.verifyContent(ctx, method);
                }
                ctx.logError("Failed to access url. Status code " + statusCode);
            }
            catch (IOException e) {
                ctx.logError("Failed to access url " + this.url + ". Error " + e.getClass().getName() + ", msg: " + e.getMessage());
            }
            ctx.logOutput("Attempting retry " + (i + 1) + " of " + this.noOfRetries + " in " + this.retryWaitInterval + " seconds");
            this.waitFor(this.retryWaitInterval);
        }
        return Step.Result.Fail;
    }

    private Step.Result verifyContent(DeploymentExecutionContext ctx, GetMethod method) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        Pattern pattern = Pattern.compile(this.expectedResponseText);
        Step.Result result = Step.Result.Fail;
        while ((line = reader.readLine()) != null) {
            if (this.showPageInConsole) {
                ctx.logOutput(line);
            }
            if (result != Step.Result.Fail) continue;
            result = this.matchLine(ctx, pattern, line);
        }
        if (result == Step.Result.Fail) {
            ctx.logError("Failed to find content '" + this.expectedResponseText + "' in page.");
        }
        return Step.Result.Success;
    }

    private Step.Result matchLine(DeploymentExecutionContext ctx, Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            ctx.logOutput("Successfully found content '" + this.expectedResponseText + "' in page.");
            return Step.Result.Success;
        }
        return Step.Result.Fail;
    }

    private void waitFor(int seconds) throws InterruptedException {
        if (seconds > 0) {
            Thread.sleep(seconds * 1000);
        }
    }
}

