/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.tests.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.MDC;

public class RemoteHttpTesterStep
extends ScriptExecutionStep {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;
    private int startDelay;
    private int noOfRetries;
    private int retryWaitInterval;

    public RemoteHttpTesterStep(int order, String scriptPath, Container container, Map<String, Object> vars, String description, int startDeplay, int noOfRetries, int retryWaitInterval) {
        super(order, scriptPath, container, vars, description);
        this.scriptTemplatePath = scriptPath;
        this.vars = vars;
        this.startDelay = startDeplay;
        this.noOfRetries = noOfRetries;
        this.retryWaitInterval = retryWaitInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            String osSpecificTemplate = this.resolveOsSpecificTemplate();
            String executableContent = this.evaluateTemplate(osSpecificTemplate, this.vars);
            this.logger.debug(executableContent);
            OverthereFile executable = this.uploadExecutable(executableContent, this.substringAfterLast(osSpecificTemplate, '/'));
            Step.Result result = this.executeScript(executable);
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    protected Step.Result executeScript(OverthereFile executable) {
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        ExecutionContextOverthereProcessOutputHandler handle = new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)this.getCtx());
        this.getCtx().logOutput("Waiting for " + this.startDelay + " secs before executing step");
        this.waitFor(this.startDelay);
        int rc = this.execute(executable, cmdLine, (OverthereProcessOutputHandler)handle);
        if (rc != 0) {
            for (int i = 0; i < this.noOfRetries; ++i) {
                this.getCtx().logOutput("\n");
                this.getCtx().logOutput("Attempting retry " + (i + 1) + " of " + this.noOfRetries + " in " + this.retryWaitInterval + " seconds");
                this.waitFor(this.retryWaitInterval);
                rc = this.execute(executable, cmdLine, (OverthereProcessOutputHandler)handle);
                if (rc == 0) break;
            }
        }
        return rc == 0 ? Step.Result.Success : Step.Result.Fail;
    }

    private int execute(OverthereFile executable, CmdLine cmdLine, OverthereProcessOutputHandler handle) {
        this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
        int rc = this.getRemoteConnection().execute(handle, cmdLine);
        if (rc != 0) {
            this.getCtx().logError("Execution failed with return code " + rc);
        }
        return rc;
    }

    private void waitFor(int seconds) {
        try {
            if (seconds > 0) {
                Thread.sleep(seconds * 1000);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private OverthereFile uploadExecutable(String content, String fileName) {
        OverthereFile targetExecutable = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)targetExecutable);
        targetExecutable.setExecutable(true);
        return targetExecutable;
    }

    private String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment(vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper((FileUploader)new WorkingFolderUploader())).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveOsSpecificTemplate() {
        String osSpecificScript = this.scriptTemplatePath;
        String scriptExt = this.substringAfterLast(this.scriptTemplatePath, '.');
        if (scriptExt == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificScript = osSpecificScript + os.getScriptExtension();
        }
        if (!this.classpathResourceExists(osSpecificScript)) {
            throw new IllegalArgumentException("Resource " + osSpecificScript + " not found in classpath");
        }
        return osSpecificScript;
    }

    private boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    private String substringAfterLast(String str, char sub) {
        int pos = str.lastIndexOf(sub);
        if (pos == -1) {
            return null;
        }
        return str.substring(pos + 1);
    }

    private class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();

        private WorkingFolderUploader() {
        }

        public String upload(OverthereFile file) {
            if (this.uploadedFiles.containsKey(file.getName())) {
                return this.uploadedFiles.get(file.getName());
            }
            OverthereFile uploadedFile = RemoteHttpTesterStep.this.getRemoteWorkingDirectory().getFile(file.getName());
            file.copyTo(uploadedFile);
            this.uploadedFiles.put(file.getName(), uploadedFile.getPath());
            return uploadedFile.getPath();
        }
    }
}

