<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
#!/bin/bash
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
cd "${container.home}"

check_status() {
    echo pid: $pid
    if [ $? != 0 ] || [ ! -z "$pid" ] ; then
        echo "Server is not stopped, Check the log and commands"
        echo pid: $pid
        exit 1
    else
        echo "Server is successfully stopped"
        exit 0
    fi
}

execute_status_command() {
    <#if container.statusCommand??>
        ${container.statusCommand}
    <#elseif container.tomcatRunningPort??>
        pid=$(lsof -t -i :${container.tomcatRunningPort} -s)
    <#else>
        echo "Tomcat running status is not checked. To check, set status command or port"
        echo "Executed stop command"
        ${container.stopCommand}
        exit 0
    </#if>
}

check_initial_status() {
    execute_status_command
    if [ $? -eq 0 ] && [ ! -z "$pid" ] ; then
        status=RUNNING
    elif [ $? -eq 0 ] ; then
        echo "Check the status command"
    else
        status=STOPPED
    fi
}

check_initial_status
if [ "$status" != "STOPPED" ] ; then
    ${container.stopCommand}
    sleep ${container.serverShutdownTime}s
    execute_status_command
    check_status
else
    echo "Server is already stopped, nothing to do"
fi
