/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

public class RenameFileStep
extends GenericBaseStep {
    private String source;
    private String target;

    public RenameFileStep(int n, String string, String string2, String string3, HostContainer hostContainer) {
        super(n, string3, hostContainer);
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string));
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string2));
        this.source = string;
        this.target = string2;
    }

    protected Step.Result doExecute() throws Exception {
        OverthereFile overthereFile = this.getRemoteConnection().getFile(this.source);
        OverthereFile overthereFile2 = this.getRemoteConnection().getFile(this.target);
        if (overthereFile2.exists()) {
            ((DeploymentExecutionContext)this.getCtx()).logError("Source file " + this.source + " cannot be renamed to " + this.target + ", because file already exists.");
            return Step.Result.Fail;
        }
        ((DeploymentExecutionContext)this.getCtx()).logOutput("Copying file " + this.source + " to " + this.target + ".");
        overthereFile.copyTo(overthereFile2);
        ((DeploymentExecutionContext)this.getCtx()).logOutput("Removing file " + this.source);
        overthereFile.deleteRecursively();
        return Step.Result.Success;
    }
}

