/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.contributor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextWarModule;
import java.util.List;

public class ContextXmlCleanup {
    @Contributor
    public static void cleanupContextXml(Deltas deltas, DeploymentPlanningContext result) {
        Iterable<Delta> deltasTargetedToVirtualHosts = ContextXmlCleanup.findDeltasTargetedToVirtualHosts(deltas);
        ListMultimap<CleanupKey, Delta> deltasPerWebApp = ContextXmlCleanup.groupByVirtualHostAndWebContext(deltasTargetedToVirtualHosts);
        for (CleanupKey key : deltasPerWebApp.keySet()) {
            List webAppDeltas = deltasPerWebApp.get((Object)key);
            boolean undeploymentInProgress = ContextXmlCleanup.undeploymentInProgress(webAppDeltas);
            Optional<Delta> optional = ContextXmlCleanup.findWarModule(webAppDeltas);
            if (!optional.isPresent()) continue;
            Delta warDelta = (Delta)optional.get();
            ContextWarModule warModule = (ContextWarModule)ContextXmlCleanup.getDeployed(warDelta);
            if (undeploymentInProgress) {
                if (!warModule.isManageContextXml()) continue;
                result.addStep((Step)ContextXmlCleanup.createDeleteStep((HostContainer)warModule.getContainer(), warModule.getDestroyOrderOfContextXml() + 1, warModule.getContextXmlTargetDirectory(), key.getContext()));
                continue;
            }
            if (warDelta.getOperation() != Operation.DESTROY) continue;
            throw new RuntimeException("There are still resources referencing the WAR. A WAR can only be undeployed when associated resources are also undeployed.");
        }
    }

    private static Optional<Delta> findWarModule(List<Delta> webAppDeltas) {
        return Iterables.tryFind(webAppDeltas, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.getDeployed(input);
                return deployed instanceof ContextWarModule;
            }
        });
    }

    private static boolean undeploymentInProgress(List<Delta> webAppDeltas) {
        return Iterables.all(webAppDeltas, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                return input.getOperation() == Operation.DESTROY;
            }
        });
    }

    private static Deployed<?, ?> getDeployed(Delta delta) {
        return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
    }

    private static Iterable<Delta> findDeltasTargetedToVirtualHosts(Deltas deltas) {
        final Type APPLICATION_CONTEXT_TYPE = Type.valueOf((String)"tomcat.VirtualHost");
        return FluentIterable.from((Iterable)deltas.getDeltas()).filter((Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.getDeployed(input);
                if (deployed.getContainer().getType().getDescriptor().isAssignableTo(APPLICATION_CONTEXT_TYPE)) {
                    return deployed instanceof ContextElement || deployed instanceof ContextWarModule;
                }
                return false;
            }
        });
    }

    private static ListMultimap<CleanupKey, Delta> groupByVirtualHostAndWebContext(Iterable<Delta> deltas) {
        return Multimaps.index(deltas, (Function)new Function<Delta, CleanupKey>(){

            public CleanupKey apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.getDeployed(input);
                String context = deployed instanceof ContextElement ? ((ContextElement)deployed).getContext() : ((ContextWarModule)deployed).getContextRoot();
                return new CleanupKey(context, deployed.getContainer().getId());
            }
        });
    }

    private static ArtifactDeleteStep createDeleteStep(HostContainer container, int order, String targetDirectory, String context) {
        ArtifactDeleteStep step = new ArtifactDeleteStep(order, container, targetDirectory);
        step.setTargetFile(context + ".xml");
        step.setDescription("Removing " + context + " xml from " + targetDirectory);
        return step;
    }

    private static class CleanupKey {
        private final String context;
        private final String containerId;

        public CleanupKey(String context, String containerId) {
            this.context = context;
            this.containerId = containerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupKey that = (CleanupKey)o;
            if (this.containerId != null ? !this.containerId.equals(that.containerId) : that.containerId != null) {
                return false;
            }
            return !(this.context != null ? !this.context.equals(that.context) : that.context != null);
        }

        public int hashCode() {
            int result = this.context != null ? this.context.hashCode() : 0;
            result = 31 * result + (this.containerId != null ? this.containerId.hashCode() : 0);
            return result;
        }

        public String getContext() {
            return this.context;
        }

        public String getContainerId() {
            return this.containerId;
        }
    }
}

