package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base type for all Tomcat resources")
public class ContextElement<D extends Deployable> extends ProcessedTemplate<D> {

    @Property(required = false, description = "The name of the context that this resource is associated with")
    private String context;

    private boolean destroyOperation;
    private boolean createOperation;

    @Override
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        createOperation = true;
        super.executeCreate(ctx, delta);
    }

    @Override
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        @SuppressWarnings("unchecked")
        ContextElement<D> previous = (ContextElement<D>) delta.getPrevious();
        previous.executeDestroy(ctx, delta);
        executeCreate(ctx, delta);
    }

    @Override
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        destroyOperation = true;
        TemplateArtifactCopyStep step = createTemplateArtifactCopyStep(delta.getPrevious());
        step.setDescription(getDescription(getDestroyVerb()));

        ctx.addStepWithCheckpoint(new ContextElementDestroyStep(getDestroyOrder(),step), delta, Operation.DESTROY);
    }

    @Override
    public String getDescription(String verb) {
        return String.format("%s %s in %s.xml on %s", verb, getName(), getContext(), getContainer().getName());
    }

    public String getContext() {
        return resolveExpression(context);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDestroyOperation() {
        return destroyOperation;
    }

    public void setDestroyOperation(boolean destroyOperation) {
        this.destroyOperation = destroyOperation;
    }

    public boolean isCreateOperation() {
        return createOperation;
    }

    public void setCreateOperation(boolean createOperation) {
        this.createOperation = createOperation;
    }


    private static class ContextElementDestroyStep implements Step {

        private int order;
        private Step delegate;

        ContextElementDestroyStep(int order, Step delegate) {
            this.order = order;

            this.delegate = delegate;
        }

        @Override
        public int getOrder() {
            return order;
        }

        @Override
        public String getDescription() {
            return delegate.getDescription();
        }

        @Override
        public StepExitCode execute(final ExecutionContext ctx) throws Exception {
            return delegate.execute(ctx);
        }
    }
}
