/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextWarModule;
import java.util.Collections;
import java.util.List;

public class ApplicationContextNameInjector {
    @PrePlanProcessor
    public static List<Step> injectContextNameInToContextElements(DeltaSpecification spec) {
        ListMultimap<Container, Delta> deployedsPerVirtualHost = ApplicationContextNameInjector.groupByVirtualHosts(spec.getDeltas());
        for (Container virtualHost : deployedsPerVirtualHost.keySet()) {
            FluentIterable deltasForVirtualHost = FluentIterable.from((Iterable)deployedsPerVirtualHost.get((Object)virtualHost));
            FluentIterable warModules = deltasForVirtualHost.filter((Predicate)DeltaTypePredicate.CONTEXT_WAR_MODULES);
            FluentIterable contextElements = deltasForVirtualHost.filter((Predicate)DeltaTypePredicate.CONTEXT_ELEMENTS);
            switch (warModules.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    ApplicationContextNameInjector.injectContextNameIntoContextElementsForSingleWar((Delta)warModules.get(0), (FluentIterable<Delta>)contextElements);
                    break;
                }
                default: {
                    ApplicationContextNameInjector.injectContextNameIntoContextElementsForMultipleWar((FluentIterable<Delta>)warModules, (FluentIterable<Delta>)contextElements);
                }
            }
            ApplicationContextNameInjector.validateAllContextElementsTargetedToVirtualHostHasCtxNameSet((FluentIterable<Delta>)contextElements);
        }
        return Collections.emptyList();
    }

    private static ListMultimap<Container, Delta> groupByVirtualHosts(Iterable<Delta> deltas) {
        Iterable<Delta> deltasTargetedToVirtualHosts = ApplicationContextNameInjector.findDeltasTargetedToVirtualHosts(deltas);
        return Multimaps.index(deltasTargetedToVirtualHosts, (Function)new Function<Delta, Container>(){

            public Container apply(Delta input) {
                Deployed deployed = ApplicationContextNameInjector.getDeployed(input);
                return deployed.getContainer();
            }
        });
    }

    private static void injectContextNameIntoContextElementsForSingleWar(Delta warModuleDelta, FluentIterable<Delta> contextElements) {
        ContextWarModule warModule = (ContextWarModule)warModuleDelta.getDeployed();
        ContextWarModule previousWarModule = (ContextWarModule)warModuleDelta.getPrevious();
        for (Delta ceDelta : contextElements) {
            ContextElement ce = (ContextElement)ApplicationContextNameInjector.getDeployed(ceDelta);
            if (Strings.isNullOrEmpty((String)ce.getContext())) {
                ce.setContext(warModule.getContextRoot());
                continue;
            }
            if (previousWarModule == null || !previousWarModule.getContextRoot().equals(ce.getContext())) continue;
            warModule = warModule == null ? previousWarModule : warModule;
            ce.setContext(warModule.getContextRoot());
        }
    }

    private static void injectContextNameIntoContextElementsForMultipleWar(FluentIterable<Delta> warModules, FluentIterable<Delta> contextElements) {
        FluentIterable warModulesBeingCreated = warModules.filter((Predicate)DeltaOperationPredicate.CREATE);
        if (warModulesBeingCreated.size() == 1) {
            ApplicationContextNameInjector.injectContextNameIntoContextElementsForSingleWar((Delta)warModulesBeingCreated.get(0), contextElements);
        } else {
            ApplicationContextNameInjector.validateAllContextElementsTargetedToVirtualHostHasCtxNameSet(contextElements);
        }
        FluentIterable otherWarModules = warModules.filter(Predicates.not((Predicate)DeltaOperationPredicate.CREATE));
        for (Delta otherWarModule : otherWarModules) {
            ApplicationContextNameInjector.injectContextNameIntoContextElementsForSingleWar(otherWarModule, contextElements);
        }
    }

    private static void validateAllContextElementsTargetedToVirtualHostHasCtxNameSet(FluentIterable<Delta> contextElements) {
        for (Delta ceDelta : contextElements) {
            ContextElement ce = (ContextElement)ApplicationContextNameInjector.getDeployed(ceDelta);
            Preconditions.checkState((Strings.emptyToNull((String)ce.getContext()) != null ? 1 : 0) != 0, (String)"Context for resource %s targeted to %s cannot be determined. Please specify the context.", (Object)ce.getName(), (Object)((HostContainer)ce.getContainer()).getName());
        }
    }

    private static Iterable<Delta> findDeltasTargetedToVirtualHosts(Iterable<Delta> deltas) {
        final Type APPLICATION_CONTEXT_TYPE = Type.valueOf((String)"tomcat.VirtualHost");
        return FluentIterable.from(deltas).filter((Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                Deployed deployed = ApplicationContextNameInjector.getDeployed(input);
                if (deployed.getContainer().getType().getDescriptor().isAssignableTo(APPLICATION_CONTEXT_TYPE)) {
                    return deployed instanceof ContextElement || deployed instanceof ContextWarModule;
                }
                return false;
            }
        });
    }

    private static Deployed<?, ?> getDeployed(Delta delta) {
        return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
    }

    static enum DeltaOperationPredicate implements Predicate<Delta>
    {
        CREATE(Operation.CREATE),
        DESTROY(Operation.DESTROY),
        MODIFY(Operation.MODIFY),
        NOOP(Operation.NOOP);

        private Operation op;

        private DeltaOperationPredicate(Operation op) {
            this.op = op;
        }

        public boolean apply(Delta input) {
            return input.getOperation() == this.op;
        }
    }

    static enum DeltaTypePredicate implements Predicate<Delta>
    {
        CONTEXT_ELEMENTS(ContextElement.class),
        CONTEXT_WAR_MODULES(ContextWarModule.class);

        private Class<?> type;

        private DeltaTypePredicate(Class<?> type) {
            this.type = type;
        }

        public boolean apply(Delta input) {
            return this.type.isInstance(this.getDeployed(input));
        }

        private Deployed<?, ?> getDeployed(Delta delta) {
            return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
        }
    }
}

