package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public enum TaskState implements TriggerState<TaskExecutionState2> {

    ANY(null,null),

    QUEUED(TaskExecutionState2.QUEUED, newHashSet(TaskExecutionState2.EXECUTING)),

    PENDING(TaskExecutionState2.PENDING, newHashSet(TaskExecutionState2.QUEUED,
                                                    TaskExecutionState2.SCHEDULED)),

    EXECUTING(TaskExecutionState2.EXECUTING, newHashSet(TaskExecutionState2.EXECUTED,
                                                        TaskExecutionState2.FAILING,
                                                        TaskExecutionState2.STOPPING,
                                                        TaskExecutionState2.ABORTING,
                                                        TaskExecutionState2.FAILED,
                                                        TaskExecutionState2.STOPPED,
                                                        TaskExecutionState2.ABORTED)),

    DONE(TaskExecutionState2.DONE, Sets.<TaskExecutionState2>newHashSet()),

    STOPPED(TaskExecutionState2.STOPPED, newHashSet(TaskExecutionState2.SCHEDULED,
                                                    TaskExecutionState2.CANCELLED,
                                                    TaskExecutionState2.QUEUED)),

    EXECUTED(TaskExecutionState2.EXECUTED, newHashSet(TaskExecutionState2.DONE)),

    CANCELLED(TaskExecutionState2.CANCELLED, Sets.<TaskExecutionState2>newHashSet()),

    // New states added with TaskExecutionState2
    FAILING(TaskExecutionState2.FAILING, newHashSet(TaskExecutionState2.FAILED,
                                                    TaskExecutionState2.ABORTING)),

    FAILED(TaskExecutionState2.FAILED, newHashSet(TaskExecutionState2.SCHEDULED,
                                                  TaskExecutionState2.CANCELLED,
                                                  TaskExecutionState2.QUEUED)),

    STOPPING(TaskExecutionState2.STOPPING, newHashSet(TaskExecutionState2.STOPPED,
                                                      TaskExecutionState2.ABORTING)),

    ABORTING(TaskExecutionState2.ABORTING, newHashSet(TaskExecutionState2.ABORTED)),

    ABORTED(TaskExecutionState2.ABORTED, newHashSet(TaskExecutionState2.SCHEDULED,
                                                    TaskExecutionState2.CANCELLED,
                                                    TaskExecutionState2.QUEUED)),

    SCHEDULED(TaskExecutionState2.SCHEDULED, newHashSet(TaskExecutionState2.QUEUED,
                                                        TaskExecutionState2.SCHEDULED))
    ;



    private TaskExecutionState2 taskExecutionState;
    private Set<TaskExecutionState2> validToTransition;

    private TaskState(TaskExecutionState2 taskExecutionState, Set<TaskExecutionState2> validToTransition) {
        this.taskExecutionState = taskExecutionState;
        this.validToTransition = validToTransition;
    }

    public boolean equivalentTo(TaskExecutionState2 spiState) {
        if (spiState == null) {
            return false;
        }
        return (taskExecutionState == null) || (taskExecutionState == spiState);
    }

    public boolean isValidTransition(TaskState toState) {
        if (taskExecutionState == null || toState.taskExecutionState == null) {  //ANY state
            return true;
        }

        return validToTransition.contains(toState.taskExecutionState);
    }
}
