def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList
    
def findAppserverComponent(components):
    allComponents = wsadminToList(components)
    for component in allComponents:
        if component.find('#ApplicationServer_') != -1:
            return component
    return None

def findEjbComponent(components):
    allComponents = wsadminToList(components)
    for component in allComponents:
        if component.find('#EJBContainer_') != -1:
            return component
    return None

def findMemberOfClusterByServerName(members, servername):
    allMembers = wsadminToList(members)
    for member in allMembers:
        membername = AdminConfig.showAttribute(member, 'memberName')
        if membername == servername:
            return member
    return None

def setEjbTimerSetting(server, jndiName, findAppserverComponent, findEjbComponent):
    components = AdminConfig.showAttribute(server, 'components')
    appserver = findAppserverComponent(components)
    components = AdminConfig.showAttribute(appserver, 'components')
    ejbcontainer = findEjbComponent(components)
    timerSettings = AdminConfig.showAttribute(ejbcontainer, 'timerSettings')
    adminConfigModify(timerSettings, '[[schedulerJNDIName "%s"]]' % jndiName)

scope = deployed.scope

if scope == 'cell':
    try:
        # should have a property 'host' and property 'nodeAgents'
        host = deployed.container.host
        nodeAgents = deployed.container.nodeAgents
    except:
        print 'ERROR you are deploying a scheduler with scope: "cell" to a container that is not a cell. Its id: ' + deployed.container.id
        sys.exit(1)
    print 'Creating a Scheduler on cell scope'
    cellName = deployed.container.name
    adminConfigCreate('SchedulerConfiguration', AdminConfig.getid('/Cell:%s/SchedulerProvider:SchedulerProvider/' % cellName), '[[name "%s"] [pollInterval "%s"] [tablePrefix "%s"] [category ""] [datasourceJNDIName "%s"] [workManagerInfoJNDIName "%s"] [useAdminRoles "false"] [jndiName "%s"] [datasourceAlias ""] [description ""]]' % (deployed.schedulerName, deployed.pollInterval, deployed.tablePrefix, deployed.datasourceJndiName, deployed.workManagerJndiName, deployed.jndiName))
elif scope == 'cluster':
    try:
        # should have a property 'cell' and property 'servers'
        cell = deployed.container.cell
        servers = deployed.container.servers
    except:
        print 'ERROR you are deploying a scheduler with scope: "cluster" to a container that is not a cluster. Its id: ' + deployed.container.id
        sys.exit(1)
    cellName = deployed.container.cell.name
    clusterName = deployed.container.name
    adminConfigCreate('SchedulerConfiguration', AdminConfig.getid('/Cell:%s/ServerCluster:%s/SchedulerProvider:SchedulerProvider/' % (cellName, clusterName)), '[[name "%s"] [pollInterval "%s"] [tablePrefix "%s"] [category ""] [datasourceJNDIName "%s"] [workManagerInfoJNDIName "%s"] [useAdminRoles "false"] [jndiName "%s"] [datasourceAlias ""] [description ""]]' % (deployed.schedulerName, deployed.pollInterval, deployed.tablePrefix, deployed.datasourceJndiName, deployed.workManagerJndiName, deployed.jndiName))
else:
    print 'ERROR unsupported scope: ' + scope
    sys.exit(1)

# now set the EJB timer services. NB for scope cluster check that the servers to be configured are indeed members!!!
# and for scope cell check that the selected servers are managed by the cell

if scope == 'cell':
    for server in deployed.ejbTimerServiceServers:
        serverName = server.name
        server = AdminConfig.getid('/Server:%s' % serverName)
        mandatorySubstring = '%s(cells/%s/nodes/' % (serverName, cellName)
        if server is None or server == '' or server.find(mandatorySubstring) == -1:
            print 'ERROR can not find server named "' + serverName + '" on cell "' + cellName
            sys.exit(1)
        else:
            print 'Setting EJB timer service of server with name: ' + serverName
            setEjbTimerSetting(server, deployed.jndiName, findAppserverComponent, findEjbComponent)
else:
    clusterName = deployed.container.name
    cluster = AdminConfig.getid('/ServerCluster:%s' % clusterName)
    members = AdminConfig.showAttribute(cluster, 'members')
    for server in deployed.ejbTimerServiceServers:
        member = findMemberOfClusterByServerName(members, server.name)
        if member is None:
            print 'ERROR can not find server named "' + serverName + '" in cluster "' + clusterName
            sys.exit(1)
        else:
            memberName = AdminConfig.showAttribute(member, 'memberName')
            print 'Setting EJB timer service of cluster member with name: ' + memberName
            nodeName = AdminConfig.showAttribute(member, 'nodeName')
            server = AdminConfig.getid('/Node:%s/Server:%s' % (nodeName, memberName))
            setEjbTimerSetting(server, deployed.jndiName, findAppserverComponent, findEjbComponent)
