containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find target container '%s' at containment path '%s'" % (deployed.container.name, deployed.container.containmentPath))

if hasattr(deployed, 'applicationServer') and deployed.applicationServer is not None:
  bindingLocation = 'SINGLESERVER'
  applicationServerName = deployed.applicationServer.name
elif hasattr(deployed, 'applicationCluster') and deployed.applicationCluster is not None:
  bindingLocation = 'SERVERCLUSTER'
  applicationServerName = deployed.applicationCluster.name
else:
  print "Either 'applicationServer' or 'applicationCluster' must be set"
  sys.exit(1)

args = toAdminConfigArgs({'name': deployed.name, 'nameInNameSpace': deployed.nameInNameSpace, 'bindingLocation': bindingLocation, 'applicationServerName': applicationServerName, 'ejbJndiName': deployed.ejbJndiName})

print "Creating EJB name space binding %s using args %s" % (deployed.name, args)
adminConfigCreate('EjbNameSpaceBinding', containerId, args)