def toEnclosedArgString(properties, startChar, endChar):
    argString = ""
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                argString += "%s%s %s%s" % (startChar, propName, str(propValue.name), endChar)
            else:
                argString += "%s%s %s%s" % (startChar, propName, str(propValue), endChar)
    return "%s%s%s" % (startChar, argString, endChar)

if deployed.conditionType == 'AGE':
    conditionParams = deployed.ConditionParamsAge.getExposedProperties(True)
    # for some unknown reason, WebSphere expects days to be passed as 'MINUTES'
    if conditionParams['ageUnits'] == 'DAYS':
        conditionParams['ageUnits'] = 'MINUTES'
elif deployed.conditionType == 'WORKLOAD':
    conditionParams = deployed.ConditionParamsWorkload.getExposedProperties(True)
elif deployed.conditionType == 'MEMORY_LEAK':
    conditionParams = deployed.ConditionParamsMemoryLeak.getExposedProperties(True)
elif deployed.conditionType == 'EXCESSIVE_MEMORY':
    conditionParams = deployed.ConditionParamsExcessiveMemory.getExposedProperties(True)
elif deployed.conditionType == 'EXCESSIVE_RESPONSE_TIME':
    conditionParams = deployed.ConditionParamsExcessiveResponseTime.getExposedProperties(True)
elif deployed.conditionType == 'EXCESSIVE_REQUEST_TIMEOUT':
    conditionParams = deployed.ConditionParamsExcessiveRequestTimeout.getExposedProperties(True)
elif deployed.conditionType == 'STORM_DRAIN':
    conditionParams = deployed.ConditionParamsStormDrain.getExposedProperties(True)

conditionArgs = "-type %s -params '%s'" % (deployed.conditionType, toEnclosedArgString(conditionParams, '{', '}'))

actionArgs = {deployed.Action1.type: '1'}
if deployed.Action2.type is not None:
    actionArgs[deployed.Action2.type] = '2'
if deployed.Action3.type is not None:
    actionArgs[deployed.Action3.type] = '3'

if deployed.container.wasConfigIdType == 'Cell':
    memberArg = "CELL %s" % (deployed.container.name)
elif deployed.container.wasConfigIdType == 'DynamicCluster':
    memberArg = "DYNAMIC_CLUSTER %s" % (deployed.container.name)
elif deployed.container.wasConfigIdType == 'ServerCluster':
    memberArg = "CLUSTER %s" % (deployed.container.name)
elif deployed.container.wasConfigIdType == 'Server':
    memberArg = "SERVER %s %s" % (deployed.container.name, deployed.container.nodeName)

args = "-name '%s' -reactionMode %s -addCondition [%s] -addAction %s -addMember [[%s]]" % (deployed.name, deployed.reactionMode, conditionArgs, toEnclosedArgString(actionArgs, '[', ']'), memberArg)
if deployed.description is not None:
    args += "-description '%s'" % (deployed.description)
print "Creating Health Policy %s for '%s': %s" % (deployed.name, deployed.container.name, args)
AdminTask.createHealthPolicy("[%s]" % (args))