def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def findSchedulerConfigOnCell(cellName, schedulerNameToFind, allSchedulerConfigurations):
    mandatorySubstring = '(cells/%s|' % cellName
    for scheduler in allSchedulerConfigurations:
        schedulerName = AdminConfig.showAttribute(scheduler, 'name')
        if schedulerName == schedulerNameToFind and scheduler.find(mandatorySubstring) != -1:
            return scheduler
    return None

def findSchedulerConfigOnCluster(cellName, clusterName, schedulerNameToFind, allSchedulerConfigurations):
    mandatorySubstring = '(cells/%s/clusters/%s|' % (cellName, clusterName)
    for scheduler in allSchedulerConfigurations:
        schedulerName = AdminConfig.showAttribute(scheduler, 'name')
        if schedulerName == schedulerNameToFind and scheduler.find(mandatorySubstring) != -1:
            return scheduler
    return None

schedulerConfigurations = AdminConfig.list('SchedulerConfiguration')
allSchedulerConfigurations = wsadminToList(schedulerConfigurations)
scope = deployed.scope
if scope == 'cell':
    print 'Deleting a Scheduler on cell scope'
    cellName = deployed.container.name
    schedulerConfig = findSchedulerConfigOnCell(cellName, deployed.schedulerName, allSchedulerConfigurations)
elif scope == 'cluster':
    print 'Deleting a Scheduler on cluster scope'
    cellName = deployed.container.cell.name
    clusterName = deployed.container.name
    schedulerConfig = findSchedulerConfigOnCluster(cellName, clusterName, deployed.schedulerName, allSchedulerConfigurations)

if schedulerConfig == None:
    print 'ERROR could not find scheduler with name ' + deployed.schedulerName + ' in scope ' + scope
    sys.exit(1)

AdminConfig.remove(schedulerConfig)

print 'Scheduler with name ' + deployed.schedulerName + ' in scope ' + scope + ' deleted.'