def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList
    
nodeName = deployed.container.name
cellName = deployed.container.cell.name

mandatorySubstring = '(cells/%s/nodes/%s/servers/nodeagent|server.xml#NodeAgent_' % (cellName, nodeName)

nodeAgents = AdminConfig.list('NodeAgent')
allNodeAgents = wsadminToList(nodeAgents)
theNodeAgent = None
for nodeAgent in allNodeAgents:
    if nodeAgent.find(mandatorySubstring) != -1:
        theNodeAgent = nodeAgent

if theNodeAgent is None:
    print 'ERROR can not find any nodeagent on Node ' + nodeName + ' of Cell ' + cellName
    sys.exit(1)

fileSynchronizationService = AdminConfig.showAttribute(theNodeAgent, 'fileSynchronizationService')
adminConfigCreate('Property', fileSynchronizationService, '[[validationExpression ""] [name "%s"] [description ""] [value "%s"] [required "false"]]' % (deployed.propertyName, deployed.propertyValue))

print 'Custom property called "%s" added on file synchronization service on the nodeagent of node "%s" with value "%s"' % (deployed.propertyName, deployed.container.name, deployed.propertyValue)

