package com.xebialabs.deployit.community.wasext.planning;


import static com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks.restart;
import static java.lang.Boolean.TRUE;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;

public class RestartReferencedWebservers extends ReferencedWebserverContributor {
    private static final String WEBSERVER_RESTART_REQUIRED_PROPERTY = "restartRequired";
    
    @Contributor
    public void restartWebservers(Deltas deltas, DeploymentPlanningContext ctx) {
        filterDeltas(deltas.getDeltas());

        for (ManagedWebServer webserver : getReferencedWebservers()) {
            // may be null
            if (TRUE.equals(webserver.getProperty(WEBSERVER_RESTART_REQUIRED_PROPERTY))) {
                restart(webserver, ctx);
            }
        }
    }
}
