package com.xebialabs.deployit.community.wasext.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.io.Closeables.closeQuietly;
import static com.xebialabs.overthere.util.OverthereFileCopier.copy;
import static java.lang.String.format;

@SuppressWarnings("serial")
public class GlobalWebServerPluginConfigurationCopyStep implements DeploymentStep {
    private final int order;
    private final String description;
    private final Host srcHost;
    private final Host targetHost;
    private final String pluginSrcFilePath;
    private final String pluginDestFilePath;

    public GlobalWebServerPluginConfigurationCopyStep(int order, Cell cell, BaseConfigurationItem unmanagedWebserver) {
        this.order = order;
        srcHost = cell.getCellHost();
        pluginSrcFilePath = format("%s/config/cells/plugin-cfg.xml", cell.getWasHome());
        targetHost = unmanagedWebserver.getProperty("host");
        pluginDestFilePath = checkNotNull(unmanagedWebserver.<String>getProperty("pluginConfigurationPath"), "pluginConfigurationPath");
        description = format("Copy global WebSphere plugin configuration file directly to '%s' for unmanaged webserver '%s'",
                targetHost.getName(), unmanagedWebserver.getName());
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
        OverthereConnection srcHostConnection = srcHost.getConnection();
        OverthereConnection targetHostConnection = targetHost.getConnection();
        try {
            final OverthereFile source = srcHostConnection.getFile(pluginSrcFilePath);
            final OverthereFile remote = targetHostConnection.getFile(pluginDestFilePath);
            ctx.logOutput(format("Copying generated plugin configuration file from '%s' on '%s' to '%s' on '%s'",
                    pluginSrcFilePath, srcHost, pluginDestFilePath, targetHost));
            copy(source, remote);
        } finally {
            closeQuietly(srcHostConnection);
            closeQuietly(targetHostConnection);
        }
        return Result.Success;
    }

    @Override
    public int getOrder() {
        return order;
    }
}
