target = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find WebSphere config item " + deployed.container.name);

existing = {}
# will fail if no such attribute exists
customProperties = AdminConfig.showAttribute(target, 'properties')
if customProperties != "[]":
    entries = customProperties[1:-1].split()
    for entry in entries:
        name = AdminConfig.showAttribute(entry, 'name')
        existing[name] = entry

for key, value in deployed.properties.items():
    if deployed.overwriteExisting:
        print 'Removing custom property %s' % (key)
        AdminConfig.remove(existing[key])
    else:
        currentValue = AdminConfig.showAttribute(existing[key], 'value')
        if currentValue == value:
            print 'Removing custom property %s' % (key)
            AdminConfig.remove(existing[key])
        else:
            newValue = currentValue.replace(value, 1)
            print "Removing '%s' from custom property %s. New value = %s" % (value, key, newValue)
            attr = [["name", key], ["value", newValue]]
            AdminConfig.modify(existing[key], attr)