#
providerContainmentPath = '%s/JDBCProvider:%s' % (deployed.container.containmentPath, deployed.jdbcProvider)
providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot locate JDBC Provider '%s' in the container '%s'" % (deployed.jdbcProvider, deployed.container.name))

jaasAliasName = createOrModifyJaasAuthenticationData(deployed)

args = [
    ['name', deployed.name],
    ['jndiName', deployed.jndiName],
    ['datasourceHelperClassname', deployed.datasourceHelperClassname],
    ['authDataAlias', noneToEmpty(jaasAliasName)],
    ['description', noneToEmpty(deployed.description)],
    ['xaRecoveryAuthAlias', mapToEmptyList(jaasAliasName, deployed.useJaasAliasForXaRecovery)]
]

dataSourceId = findDataSourceId(deployed)
if dataSourceId:
    print "Modifying JDBC DataSource '%s' with the arguments '%s'" % (deployed.name, args)
    adminConfigModify(dataSourceId, args)
else:
    print "Creating JDBC DataSource '%s' with the arguments '%s' in the container '%s" % (deployed.name, args, deployed.container.name)
    if not deployed.defaultDataSourceProperties:
        dataSourceId = adminConfigCreate('DataSource', providerId, args)
    else:
        adminTaskArgs = [
            ['name', "\"%s\"" % (deployed.name)],
            ['jndiName', "\"%s\"" % (deployed.jndiName)],
            ['dataStoreHelperClassName', "\"%s\"" % (deployed.datasourceHelperClassname)],
            ['configureResourceProperties', '[[databaseName java.lang.String %s]]' % deployed.databaseName]
        ]
        dataSourceId = adminConfigCreateDatasource(providerId, adminTaskArgs)

configureDataSourceConnectionPool(deployed, dataSourceId)

if deployed.containerManagedPersistence:
    if not findCmpConnectorFactory(deployed, dataSourceId):
        createCmpConnectorFactory(deployed, dataSourceId)
else:
    if findCmpConnectorFactory(deployed, dataSourceId):
        removeCmpConnectorFactory(deployed, dataSourceId)

if not deployed.defaultDataSourceProperties:
    # Reset custom property contents
    propertySet = adminConfigCreate('J2EEResourcePropertySet', dataSourceId, [], 'propertySet')
else:
    propertySet = AdminConfig.show(dataSourceId,'propertySet').strip("[]")

for propName, propValue in deployed.getExposedProperties(True).items():
    if "configureResourceProperties" not in propName:
        args = [['name', propName],['value', propValue]]
        print "Creating Custom Property '%s' " % (args)
        adminConfigCreate('J2EEResourceProperty', propertySet, args)

createCustomProps(propertySet, "J2EEResourceProperty", deployed)

createOrModifyMappingModule(deployed, dataSourceId, jaasAliasName)
