#
import sys
import traceback

def isNetworkDeploymentEdition(container):
    return container.wasConfigIdType == 'Cell'

def inspectCellName(container):
    # Inspect cell name
    try:
        cell = AdminConfig.list('Cell')
        cellName = AdminConfig.showAttribute(cell, 'name')
    except:
        print >> sys.stderr, "Cannot get cell information. Have you entered the correct username and password to administer WebSphere Application Server?"
        traceback.print_exc()
        sys.exit(1)

    if container.wasConfigIdType == 'Cell':
        if container.name != cellName:
            print >> sys.stderr, "Cell name is %s instead of %s. Please set the correct ID for the was.DeploymentManager CI." % (cellName, container.name)
            sys.exit(1)
    else:
        inspected('cellName', cellName)
        servers= wsadminToList(AdminTask.listServers('[-serverType APPLICATION_SERVER ]'))
        found = False
        for server in servers:
            serverName = server[0:server.find("(")]
            if container.name == serverName:
                found = True
        if not found:
            print >> sys.stderr, "Server with name %s not found. Available servers are %s. Please set the correct ID for the was.UnmanagedServer CI." % (container.name,[server.encode('utf-8') for server in servers])
            sys.exit(1)

########################################################################################################################
#
# Function to discover and inspect a Websphere Base installation.
# Managed Webservers are automatically discovered/inspected.
# Use the callback mechanism to inspect additional properties.
#
# container : The container (was.UnmanagedServer).
#
# webserverInspectCallback : if the caller wishes to inspect additional information for webserver.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the webserver.
#
########################################################################################################################
def discoverAndInspectBaseEditionContainers(container, webserverInspectCallback=None):
    nodes = wsadminToList(AdminConfig.list('Node'))
    if container.wasConfigIdType != 'Cell' and len(nodes) == 1:
        # Discover SA
        inspected('nodeName', AdminConfig.showAttribute(nodes[0], 'name'))

########################################################################################################################
#
# Function to discover and inspect a Websphere ND installation.
# Nodes, Application Servers, Managed Webservers and Clusters automatically discovered/inspected.
# Use the callback mechanism to inspect additional properties.
#
# container : The container (was.DeploymentManager).
#
# nodeInspectCallback : if the caller wishes to inspect additional information for the node.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the node.
#
# webserverInspectCallback : if the caller wishes to inspect additional information for webserver.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the webserver.
#
# appserverInspectCallback : if the caller wishes to inspect additional information for application server.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the application server.
#
# clusterInspectCallback : if the caller wishes to inspect additional information for cluster.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the cluster.
#
#
########################################################################################################################
def discoverAndInspectNetworkDeploymentEditionContainers(container, nodeInspectCallback=None, webserverInspectCallback=None, appserverInspectCallback=None, clusterInspectCallback=None, appendTypeToName=False):
    # Discover ND
    # Discover was.UnmanagedNode instances
    unmanagedNodes = wsadminToList(AdminTask.listUnmanagedNodes())
    for nodeName in unmanagedNodes:
        nodeId = '%s/%s' % (container.id, nodeName)
        print "Discovered unmanaged node : %s" % nodeId
        discovered(nodeId, 'was.UnmanagedNode')
        nodeServers = wsadminToList(AdminConfig.getid('/Node:%s/Server:/' % (nodeName)))
        for s in nodeServers:
            wasServerType = AdminConfig.showAttribute(s, 'serverType')
            nodeServerId = nodeId + '/' + AdminConfig.showAttribute(s, 'name')
            if wasServerType == 'WEB_SERVER':
                discovered(nodeServerId, 'was.ManagedWebServer')
                if webserverInspectCallback:
                    webserverInspectCallback(nodeServerId,s)
                inspectedItem(nodeServerId)
            else:
                print "WARNING: Detected server type: %s with id: %s. Skipping discovery." % (wasServerType, nodeServerId)
                continue
        inspectedItem(nodeId)

    nodes = wsadminToList(AdminConfig.list('Node'))
    # Discover was.NodeAgent instances - skip Nodes that have no corresponding NodeAgent
    nodeagents = AdminConfig.list('NodeAgent')
    for node in nodes:
        nodeName = AdminConfig.showAttribute(node, 'name')
        if nodeagents.find('/nodes/%s/servers' % (nodeName)) != -1:
            nodeId = '%s/%s' % (container.id, nodeName)
            discovered(nodeId, 'was.NodeAgent')
            if nodeInspectCallback:
                nodeInspectCallback(nodeId, node)
            nodeServers = wsadminToList(AdminConfig.getid('/Node:%s/Server:/' % (nodeName)))
            for s in nodeServers:
                wasServerType = AdminConfig.showAttribute(s, 'serverType')
                nodeServerId = nodeId + '/' + AdminConfig.showAttribute(s, 'name')

                if wasServerType == 'WEB_SERVER':
                    discovered(nodeServerId, 'was.ManagedWebServer')
                    if webserverInspectCallback:
                        webserverInspectCallback(nodeServerId,s)
                    inspectedItem(nodeServerId)
                elif wasServerType == 'APPLICATION_SERVER':
                    discovered(nodeServerId, 'was.ManagedServer')
                    if appserverInspectCallback:
                        appserverInspectCallback(nodeServerId,s)
                    inspectedItem(nodeServerId)
                elif wasServerType == 'PROXY_SERVER':
                    discovered(nodeServerId, 'was.ManagedServer')
                    if appserverInspectCallback:
                        appserverInspectCallback(nodeServerId, s)
                    inspectedItem(nodeServerId)
                else:
                    print "WARNING: Detected server type: %s with id: %s. Skipping discovery." % (wasServerType, nodeServerId)
                    continue
            inspectedItem(nodeId)

    # Discover was.DynamicCluster instances
    dynClusterNames = []
    if AdminConfig.types().find('DynamicCluster') > -1:
        dynClusters = wsadminToList(AdminConfig.list('DynamicCluster'))
        for dynCluster in dynClusters:
            name = AdminConfig.showAttribute(dynCluster, 'name')
            dynClusterNames.append(name)
            dynClusterId = "%s/%s" % (container.id, name)
            dynClusterType = AdminConfig.showAttribute(dynCluster, 'serverType')
            if dynClusterType == 'APPLICATION_SERVER':
                if appendTypeToName:
                    dynClusterId = dynClusterId + '_was.DynamicCluster'
                discovered(dynClusterId, 'was.DynamicCluster')
                inspectedProperty(dynClusterId, 'wasName', name)
            elif dynClusterType == 'ONDEMAND_ROUTER':
                if appendTypeToName:
                    dynClusterId = dynClusterId + '_was.DynamicOdrCluster'
                discovered(dynClusterId, 'was.DynamicOdrCluster')
                inspectedProperty(dynClusterId, 'wasName', name)
            else:
                print "INFO: Ignoring unsupported dynamic cluster type '%s'" % (dynClusterType)
                continue

            for p in ['membershipPolicy', 'minInstances', 'maxInstances', 'numVerticalInstances', 'operationalMode']:
                inspectedProperty(dynClusterId, p, AdminConfig.showAttribute(dynCluster, p))

            if clusterInspectCallback:
                clusterInspectCallback(dynClusterId, dynCluster)

            inspectedItem(dynClusterId)

    # Discover was.Cluster instances
    clusters = wsadminToList(AdminConfig.list('ServerCluster'))
    for cluster in clusters:
        clusterName = AdminConfig.showAttribute(cluster, 'name')
        # dynamic clusters *also* show up as ServerClusters
        if clusterName not in dynClusterNames:
            clusterType = AdminConfig.showAttribute(cluster, 'serverType')
            clusterId = '%s/%s' % (container.id, clusterName)
            if clusterType == 'APPLICATION_SERVER':
                if appendTypeToName:
                    clusterId = clusterId + '_was.Cluster'
                discovered(clusterId, 'was.Cluster')
                inspectedProperty(clusterId, 'wasName', clusterName)
            elif clusterType == 'PROXY_SERVER':
                if appendTypeToName:
                    clusterId = clusterId + '_was.ProxyServerCluster'
                discovered(clusterId, 'was.ProxyServerCluster')
                inspectedProperty(clusterId, 'wasName', clusterName)
            else:
                print "INFO: Ignoring unsupported cluster type: '%s'" % (clusterType)
                continue

            clusterServers = []
            clusterMembers = wsadminToList(AdminConfig.getid('/ServerCluster:%s/ClusterMember:/' % (clusterName)))
            for m in clusterMembers:
                clusterServers.append(container.id + '/' + AdminConfig.showAttribute(m, 'nodeName') + '/' + AdminConfig.showAttribute(m, 'memberName'))
            inspectedProperty(clusterId, 'servers', clusterServers)
            if clusterInspectCallback:
                clusterInspectCallback(clusterId,cluster)
            inspectedItem(clusterId)
