busName = deployed.name

props = deployed.getExposedProperties(True)

if getVersion(deployed.container) == 'WAS_61':
    for p in ['useServerIdForMediations', 'auditAllowed', 'securityGroupCacheTimeout', 'bootstrapPolicy']:
        if props.has_key(p):
            print "Ignoring property '%s' on Websphere 6.1" % p
            del props[p]

allowedProtocols = checkAllowedTransports(deployed)

if siBusExists(busName):
    print "Modifying Service Integration Bus '%s'" % (busName)
    updatePermittedTransports(deployed)

    for p in ['scriptCompatibility']:
        print "Ignoring property '%s' during modify" % p
        del props[p]

    args = toAdminTaskArgs(props)
    args.extend(['-bus', busName])

    print "Updating Service Integration Bus with %s" % (args)

    AdminTask.modifySIBus(args)
else:
    permittedChains = props['permittedChains']
    del props['permittedChains']

    args = toAdminTaskArgs(props)
    args.extend(['-bus', busName])

    print "Creating Service Integration Bus with arguments: ", args
    AdminTask.createSIBus(args)

    AdminTask.modifySIBus(['-bus', busName, '-permittedChains', permittedChains])
    if permittedChains == 'LISTED':
        for protocol in allowedProtocols:
            print "Adding %s to the allowed protocols" % protocol
            AdminTask.addSIBPermittedChain(['-bus', busName, '-chain', protocol])
