/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EarToWasClusterMapper
extends JeeWebArtifactToWasTargetMapper<Ear, WasEarMapping, WasCluster> {
    public EarToWasClusterMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(cluster.getCell(), mapping.getSource(), Collections.singleton(cluster), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getClassLoaderPolicy(), mapping.getWarClassLoaderMapping(), mapping.getSecurityRoleUserGroupMappings(), this.getUpdatedWebserversMapping(mapping)));
    }

    @Override
    protected void generateUndeployStep(Ear artifact, WasCluster cluster, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep((WasCell)cluster.getCell(), mapping.getSource()));
    }

    @Override
    protected void generateStartStep(Ear artifact, WasCluster cluster, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)cluster, mapping.getSource()));
    }

    @Override
    protected void generateStopStep(Ear artifact, WasCluster cluster, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)cluster, mapping.getSource()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasEarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasEarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasEarMapping mapping) {
        return mapping.getWarsWebserversVHMapping();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasEarMapping mapping) {
        return this.getWebserversAndVirtualHostPerWar(mapping);
    }
}

