/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.runbook.WasServerRunBook;
import com.xebialabs.deployit.plugin.was.step.CreateWasServerStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.ModifyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.StartWasManagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasManagedServerStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import java.io.Serializable;
import java.util.List;

public class WasManagedServerRunBook
extends WasServerRunBook<WasManagedServer>
implements RunBook {
    public WasManagedServerRunBook() {
        super(WasManagedServer.class);
    }

    @Override
    protected boolean isEligibleChange(Change<WasManagedServer> change, ChangePlan changePlan) {
        WasManagedServer server = WasManagedServerRunBook.getRevision(change);
        for (Change eachChange : changePlan.getChanges()) {
            if (!WasCluster.class.isAssignableFrom(eachChange.getConfigurationItemClass()) || !((WasCluster)WasManagedServerRunBook.getRevision(eachChange)).getServers().contains(server)) continue;
            return false;
        }
        return true;
    }

    private static <T extends Serializable> T getRevision(Change<T> change) {
        return (T)(change.isAddition() || change.isModification() ? change.getNewRevision() : change.getOldRevision());
    }

    @Override
    protected void getStepsForDeletedServer(List<Step> steps, WasManagedServer oldServer) {
        steps.add(new StopWasManagedServerStep(oldServer, false));
        steps.add(new DestroyWasServerStep(oldServer));
        steps.add(new SynchronizeWasNodeStep(oldServer.getNode()));
    }

    @Override
    public void getStepsForModifiedServer(List<Step> steps, WasManagedServer oldServer, WasManagedServer newServer) {
        steps.add(new StopWasManagedServerStep(oldServer, false));
        steps.add(new ModifyWasServerStep(newServer));
        steps.add(new SynchronizeWasNodeStep(newServer.getNode()));
        steps.add(new StartWasManagedServerStep(newServer));
    }

    @Override
    protected void getStepsForAddedServer(List<Step> steps, WasManagedServer newServer) {
        steps.add(new CreateWasServerStep(newServer));
        steps.add(new ModifyWasServerStep(newServer));
        steps.add(new SynchronizeWasNodeStep(newServer.getNode()));
        steps.add(new StartWasManagedServerStep(newServer));
    }
}

