/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Map;

public class RetrieveWasServerTuningPropertiesStep
extends WasStepBase {
    private WasServer server;

    public RetrieveWasServerTuningPropertiesStep(WasServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Retrieve TuningParams properties of server " + server);
    }

    public boolean execute(StepExecutionContext ctx) {
        String invalidationTimeout;
        Map<String, String> webContainerProperties = this.cell.getObjectInfoWithSubLevelByType(ctx, "/Server:" + this.server.getName(), "TuningParams");
        if (webContainerProperties == null) {
            ctx.logError("Server " + this.server + "with technical name " + this.server.getName() + " does not exist in cell " + this.cell);
            return false;
        }
        String maxInMemorySessionCount = webContainerProperties.get("maxInMemorySessionCount");
        if (maxInMemorySessionCount != null) {
            this.server.setMaximumSessionsInMemory(Integer.parseInt(maxInMemorySessionCount));
        }
        if ((invalidationTimeout = webContainerProperties.get("invalidationTimeout")) != null) {
            this.server.setSessionTimeout(Integer.parseInt(invalidationTimeout));
        }
        return true;
    }
}

