/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Collection;
import java.util.Collections;

public class RetrieveWasSubtypesStep
extends WasStepBase {
    public RetrieveWasSubtypesStep(WasCell cell) {
        super(cell);
        this.setDescription("Retrieve nodes, clusters, and servers from cell " + cell);
    }

    public boolean execute(StepExecutionContext ctx) {
        ctx.logOutput("Retrieving nodes...");
        Collection<String> nodes = this.cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + this.cell.getCellName(), "Node");
        if (nodes == null) {
            nodes = Collections.emptySet();
        }
        ctx.setAttribute("WasNode", nodes);
        ctx.logOutput("Retrieving nodes done. Retrieving clusters...");
        Collection<String> clusters = this.cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + this.cell.getCellName(), "ServerCluster");
        if (clusters == null) {
            clusters = Collections.emptySet();
        }
        ctx.setAttribute("WasCluster", clusters);
        ctx.logOutput("Retrieving clusters done. Retrieving servers...");
        Collection<String> servers = this.cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + this.cell.getCellName(), "Server");
        if (servers == null) {
            servers = Collections.emptySet();
        }
        ctx.setAttribute("WasServer", servers);
        ctx.logOutput("");
        ctx.logOutput("Retrieving servers done. Will now discover properties of nodes, clusters, and servers found...");
        return true;
    }
}

