/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.utils;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WasUtils {
    public static NodeList getNodesWithTag(String tag, NamedDeployableArtifact artifact, String jarEntryName) {
        try {
            JarFile jarFile = new JarFile(new File(artifact.getLocation()));
            JarEntry jarEntry = jarFile.getJarEntry(jarEntryName);
            if (jarEntry != null) {
                InputStream is = jarFile.getInputStream(jarEntry);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                WasUtils.disableDtdValidation(db);
                Document doc = db.parse(new InputSource(is));
                NodeList resourceRefNodes = doc.getElementsByTagName(tag);
                is.close();
                jarFile.close();
                return resourceRefNodes;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Ear file not found for Ear named " + artifact.getName());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Parser configuration Exception while trying to parse application.xml for Ear named " + artifact.getName());
        }
        catch (SAXException e) {
            throw new RuntimeException("Parser Exception while parsing application.xml for Ear named " + artifact.getName());
        }
    }

    public static void disableDtdValidation(DocumentBuilder db) {
        db.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                System.out.println("Ignoring " + publicId + ", " + systemId);
                return new InputSource(new StringReader(""));
            }
        });
    }

    public static String findName(Element element, String tagnameOfChild) {
        NodeList refNameElements = element.getElementsByTagName(tagnameOfChild);
        if (refNameElements.getLength() == 1) {
            Node refNameElement = refNameElements.item(0);
            return refNameElement.getFirstChild().getNodeValue();
        }
        return null;
    }
}

