/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.WasAppContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere cluster managed by a deployment manager (WAS ND)")
public class Cluster
extends BaseContainer
implements WasAppContainer {
    @Property(asContainment=true, label="Deployment manager that manages this this cluster")
    private DeploymentManager cell;
    @Property(required=false, label="Cluster members", description="Servers that are part of this cluster")
    private Set<ManagedServer> servers;

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        return this.getCell().getName();
    }

    public void setCell(DeploymentManager deploymentManager) {
        this.cell = deploymentManager;
    }

    public void setServers(Set<ManagedServer> set) {
        this.servers = set;
    }

    public Set<ManagedServer> getServers() {
        return this.servers;
    }

    public Map<NodeAgent, List<String>> getServerNamesPerNode() {
        HashMap<NodeAgent, List<String>> hashMap = new HashMap<NodeAgent, List<String>>();
        if (this.servers != null) {
            for (ManagedServer managedServer : this.servers) {
                NodeAgent nodeAgent = managedServer.getNode();
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(nodeAgent);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(nodeAgent, arrayList);
                }
                arrayList.add(managedServer.getName());
            }
        }
        return hashMap;
    }

    public Set<Node> getNodes() {
        HashSet<Node> hashSet = new HashSet<Node>();
        if (this.servers != null) {
            for (ManagedServer managedServer : this.servers) {
                hashSet.add(managedServer.getNode());
            }
        }
        return hashSet;
    }

    @Override
    public String getContainmentPath() {
        return "/ServerCluster:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "ServerCluster";
    }

    @Override
    public String getWasTargetType() {
        return "cluster";
    }

    @Override
    public String getShortTypeDescription() {
        return "cluster";
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Map<NodeAgent, List<String>> map = this.getServerNamesPerNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<NodeAgent, List<String>> entry : map.entrySet()) {
            NodeAgent nodeAgent = entry.getKey();
            List<String> list = entry.getValue();
            for (String string : list) {
                arrayList.add("cell=" + this.cell.getCellName() + ",node=" + nodeAgent.getName() + ",type=ApplicationManager,process=" + string + ",*");
            }
        }
        return arrayList;
    }

    @Inspect
    public void inspect(InspectionPlanningContext inspectionPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", this);
        inspectionPlanningContext.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "was/container/inspect-cluster.py", (Map)hashMap, "Inspect " + this));
    }
}

