#

import sys
import time

def startApplicationOnServer(appName, server):
    appMgrName = "cell=%s,node=%s,type=ApplicationManager,process=%s,*" % (server.cellName, server.nodeName, server.name)
    appMgr = AdminControl.queryNames(appMgrName)
    if appMgr == '':
        print >> sys.stderr, "Cannot (completely) start", appName,"because the server", server.name, "has not been started."
        return 1
    else:
        print "Starting application", appName, "on", server.name
        AdminControl.invoke(appMgr, 'startApplication', '["' + appName + '"]')
        print "Done."
        
    return 0

# Wait for application to be installed
while True :
    if AdminApp.isAppReady(deployed.name) == 'true':
        break;
    print "\nWaiting for", deployed.name, "deployment to finish."
    time.sleep(10)

result = 0
if (deployed.container.wasTargetType == "cluster"):
    for server in deployed.container.servers:
        if isApplicationRunningOnServer(deployed.name, server.name, server.nodeName):
            print "Application", deployed.name, "on", server.name, "already started."
        else:
            result = startApplicationOnServer(deployed.name, server)
else:
    if isApplicationRunningOnServer(deployed.name, deployed.container.name, deployed.container.nodeName):
        print "Application", deployed.name, "on", deployed.container.name, "already started."
    else:
        result = startApplicationOnServer(deployed.name, deployed.container)

sys.exit(result)
