import types
import sys

def toAdminConfigArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.append([propName, str(propValue.name)])
            else:
                args.append([propName, str(propValue)])
    return args

def toAdminTaskArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.extend(["-" + propName, str(propValue.name)])
            else:
                args.extend(["-" + propName, str(propValue)])
    return args

def validateNotEmpty(val, error):
    if val is None or val == "":
        print error
        sys.exit(1)
    return val

# Functions invoked by the PythonScriptStep

def saveConfiguration():
    if AdminConfig.hasChanges():
        print "Saving configuration"
        AdminConfig.save()

def connectFromDaemon():
    pass

def connectFromStandAloneScript():
    pass

def disconnectFromDaemon():
    pass

def disconnectFromStandAloneScript():
    saveConfiguration()

def runScriptFromDaemon(scriptPath):
    #Execute the script in its own global scope, so that functions defined in the script can find each other.
    execfile(scriptPath, globals().copy())
    saveConfiguration()

def disconnectFromDaemonForError():
    if AdminConfig.hasChanges():
        print "Discarding unsaved changes"
        AdminConfig.reset()

def isApplicationRunningOnServer(applicationName, serverName, nodeName) :
    return AdminControl.completeObjectName("type=Application,name=%s,process=%s,node=%s,*" % (applicationName, serverName, nodeName)) != ""

def findAllContainers(cell, onlyWasAppContainer=False):
    containers = []
    if cell.type == "was.UnmanagedServer":
        containers.append(cell)
    elif cell.type == "was.DeploymentManager":
        if (not onlyWasAppContainer):
            containers.append(cell)
        for cluster in cell.clusters:
            containers.append(cluster)
        for node in cell.nodeAgents:
            if (not onlyWasAppContainer):
                containers.append(node)
            for server in node.servers:
                containers.append(server)
    return containers

#*******************************************************************************************************
# convert a string as returned by AdminConfig.show[Attribute] to a Jython list
#*******************************************************************************************************
def wsadminToList(inStr):
  outList=[]
  if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
    inStr = inStr[1:-1]
    tmpList = inStr.split(" ")
  else:
    tmpList = inStr.split("\n")	 #splits for Windows or Linux
  for item in tmpList:
    item = item.rstrip();		 #removes any Windows "\r"
    if (len(item)>0):
      outList.append(item)
  return outList


#
# Transforms AdminConfig.show(xxx) to dictionary
# Example input: '[name webserver1]\n[nodeName was-61-appserver-node]'
# Will result in: {'name': 'webserver1', 'nodeName': 'was-61-appserver-node'}
#
def wsadminToDict(inStr):
    map = {}
    for l in inStr.splitlines():
        pieces = l[1:-1].split(" ")
        map[pieces[0]] = pieces[1]

    return map
#endDef
######################################################################
#
#Returns the WAS version
######################################################################
def getVersion(wasContainer):
	if hasattr(wasContainer,'version'):
	  return wasContainer.version
  	if hasattr(wasContainer, 'cell'):
	  return wasContainer.cell.version
	if hasattr(wasContainer, 'node'):
	  return wasContainer.node.cell.version	        
	
