package com.xebialabs.deployit.plugin.was.step;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.was.container.*;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class DiscoveryWasTopologyStep extends PythonInspectionStep {

    private Cell cell;
    private boolean skipDiscovery;

    public DiscoveryWasTopologyStep(BaseCell cell, boolean skipDiscovery) {
        super(cell, cell, cell.getInspectScript(), createPythonVars(cell), "Inspect " + cell);
        this.cell = cell;
        this.skipDiscovery = skipDiscovery;
    }

    private static Map<String, Object> createPythonVars(Cell cell) {
        Map<String, Object> pythonVars = newHashMap();
        pythonVars.put("container", cell);
        return pythonVars;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        if(cell instanceof DeploymentManager) {
            DeploymentManager dmgr = (DeploymentManager) cell;
            if (skipDiscovery) {
                for (Node node : dmgr.getNodes()) {
                    ctx.getInspectionContext().discovered(node);
                    ctx.getInspectionContext().inspected(node);
                    for (Server server  : ((NodeAgent)node).getServers()) {
                        ctx.getInspectionContext().discovered(server);
                        ctx.getInspectionContext().inspected(server);
                    }
                    for (ManagedWebServer server  : ((NodeAgent)node).getWebServers()) {
                        ctx.getInspectionContext().discovered(server);
                        ctx.getInspectionContext().inspected(server);
                    }
                }
                for (Cluster cluster : dmgr.getClusters()) {
                    ctx.getInspectionContext().discovered(cluster);
                    ctx.getInspectionContext().inspected(cluster);
                }
                return StepExitCode.SUCCESS;
            } else {
                dmgr.getNodes().clear();
                dmgr.getClusters().clear();
            }
        }

        return super.execute(ctx);
    }

}
