/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.Server;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Metadata(description="An unmanaged WebSphere Applicaton Server (WAS Base/SA)", inspectable=true)
public class UnmanagedServer
extends BaseCell
implements Node,
Server {
    @Property(required=true, label="WebSphere cell name", description="Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
    private String cellName;
    @Property(required=true, label="WebSphere node name", description="Name of the WebSphere node")
    private String nodeName;
    @Property(description="WebSphere web servers in the node", asContainment=true, required=false)
    private Set<ManagedWebServer> webServers = Sets.newHashSet();

    @Override
    public String getCellName() {
        return this.cellName;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    @DerivedProperty(value="node")
    public Node getNode() {
        return this;
    }

    @Override
    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Set<Node> getNodes() {
        return Collections.emptySet();
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        String appMgrObjectName = "cell=" + this.getCellName() + ",node=" + this.getNodeName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(appMgrObjectName);
    }

    @Override
    public String getContainmentPath() {
        return "/Server:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "unmanaged server";
    }

    public Set<ManagedWebServer> getWebServers() {
        return this.webServers;
    }

    public void addWebServer(ManagedWebServer webServer) {
        this.webServers.add(webServer);
    }
}

