#
providerId = validateNotEmpty(AdminConfig.getid('%s/WorkManagerProvider:%s' % (deployed.container.containmentPath, deployed.provider)), "Cannot locate  WorkManager Provider %s in container '%s'" % (deployed.provider,deployed.container.name))

exposedProperties = deployed.getExposedProperties(True)
if exposedProperties['workReqQFullAction'] == 'Block':
    exposedProperties['workReqQFullAction'] = 0
elif exposedProperties['workReqQFullAction'] == 'Fail':
    exposedProperties['workReqQFullAction'] = 1

serviceNames = ""
if deployed.ServiceNames.security:
    serviceNames = serviceNames + 'security;'
if deployed.ServiceNames.applicationProfilingService:
    serviceNames = serviceNames + 'AppProfileService;'
if deployed.ServiceNames.internationalization:
    serviceNames = serviceNames + 'com.ibm.ws.i18n;'
if deployed.ServiceNames.workArea:
    serviceNames = serviceNames + 'UserWorkArea;'
if serviceNames != "":
    serviceNames = serviceNames[:-1]

args = toAdminConfigArgs(exposedProperties)
args.append(['serviceNames', serviceNames])

print "Creating work manager with provider %s and args %s " % (deployed.provider, args)
AdminConfig.create('WorkManagerInfo', providerId, args)

