containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot locate container at path %s" %(deployed.container.containmentPath))
serverName  = deployed.container.name
serverEntries = validateNotEmpty(wsadminToList(AdminConfig.list( 'ServerEntry')), "Cannot locate ServerEntries")
serverEntryList = [serverEntry for serverEntry in serverEntries if AdminConfig.showAttribute(serverEntry, 'serverName') == serverName]
if not serverEntryList:
    raise "Cannot locate serverName with name %s" % serverName
for serverEntry in serverEntryList:
    namedEndPoints = validateNotEmpty(wsadminToList(AdminConfig.list( "NamedEndPoint" , serverEntry)), "Cannot locate NamedEndPoints in %s" %(serverEntry))
    namedEndPointList = [namedEndPoint for namedEndPoint in namedEndPoints if AdminConfig.showAttribute(namedEndPoint, 'endPointName') == deployed.name]

    if not namedEndPointList:
        printErrorAndExit("Cannot locate endPointName with name %s" % deployed.name)

    endPoint = AdminConfig.showAttribute(namedEndPointList[0], "endPoint" )
    exposedProperties = deployed.getExposedProperties(True)
    args = toAdminConfigArgs(exposedProperties)
    print 'Modify Server Port of %s with args %s' % (endPoint, args)
    AdminConfig.modify(endPoint, args)