#
def isApplicationRunningOnServer(applicationName, serverName, nodeName) :
    return AdminControl.completeObjectName("type=Application,name=%s,process=%s,node=%s,*" % (applicationName, serverName, nodeName)) != ""

def appendMapModulesToServersArg(installArgs):
    targetType=deployed.container.wasTargetType
    #Check The target type,whether cluster or server
    if(targetType=='cluster'):
        defaultTargets = "WebSphere:cell=%s,%s=%s" % (deployed.container.cellName, deployed.container.wasTargetType, deployed.container.name)
    else:
        defaultTargets = "WebSphere:cell=%s,node=%s,%s=%s" % (deployed.container.cellName, deployed.container.nodeName, deployed.container.wasTargetType, deployed.container.name)

    servermappings = []
    servermappings.append(['.*', '.*', defaultTargets])
    if hasattr(deployed, 'webServers') and len(deployed.webServers) > 0:
        webTargets = defaultTargets
        for ws in deployed.webServers:
            webTargets += "+WebSphere:cell=%s,node=%s,server=%s" %(ws.node.cellName, ws.node.nodeName, ws.name)
        servermappings.append(['.*', '.*.war,.*', webTargets])
    installArgs.extend(['-MapModulesToServers', servermappings])

def appendMapWebModToVHArg(installArgs):
    vhostmappings = []
    if hasattr(deployed, 'virtualHost') and deployed.virtualHost != None:
        vhostmappings.append(['.*', '.*', deployed.virtualHost.name])
    else:
        vhostmappings.append(['.*', '.*', 'default_host'])
    installArgs.extend(['-MapWebModToVH', vhostmappings])

def appendMapSharedLibForModArg(installArgs):
    sharedLibNames = []
    if deployed.sharedLibraries:
        for l in deployed.sharedLibraries:
            sharedLibNames.append(l.name)
    if deployed.sharedLibraryNames:
        for l in deployed.sharedLibraryNames:
            if not l in sharedLibNames:
                sharedLibNames.append(l)
            else:
                print "WARN: duplicate shared library name '%s' while deploying '%s'" % (l, deployed.name)
    if sharedLibNames:
        sharedLibraryMappings = []
        sharedLibraryMappings.append(['.*', '.*', "+".join(sharedLibNames)])
        installArgs.extend(['-MapSharedLibForMod', sharedLibraryMappings])

def appendMapRolesToUsersArg(installArgs):
    if hasattr(deployed, 'roleMappings'):
        roleMappings = []
        for role,group in deployed.roleMappings.items():
            if group == 'Everyone':
                roleMappings.append([role, 'Yes', 'No', '', ''])
            else:
                roleMappings.append([role, 'No', 'No', '', group])
        if len(roleMappings) > 0:
            installArgs.extend(['-MapRolesToUsers', roleMappings])

def appendPrecompileJspsArg(installArgs):
    # if this is an EJB deployment, the preCompileJsps property will not be present on the deployed
    if hasattr(deployed, 'preCompileJsps') and deployed.preCompileJsps:
        installArgs.extend(['-preCompileJSPs','-JSPCompileOptions', [['.*', '.*', 'jspcp', 'Yes', 15, 'No']]])

def appendUseDefaultBindingsArg(installArgs):
    installArgs.append('-usedefaultbindings')

def appendContextRootArg(installArgs):
    # if this is not a WAR deployment, the contextroot property will not be present on the deployed
    if hasattr(deployed, 'contextRoot'):
        installArgs.extend(['-contextroot', deployed.contextRoot])

def appendEditionedApplicationArgs(installArgs):
    if hasattr(deployed, 'isEdition') and deployed.isEdition:
        if hasattr(deployed, 'appEdition') and deployed.appEdition is not None:
            installArgs.extend(['-edition', deployed.appEdition])
        if hasattr(deployed, 'editionDescription') and deployed.editionDescription is not None:
            installArgs.extend(['-edition.desc', deployed.editionDescription])

def prepareInstallArgs():
    installArgs = ['-appname', deployed.name]
    appendContextRootArg(installArgs)
    appendMapModulesToServersArg(installArgs)
    appendMapWebModToVHArg(installArgs)
    appendMapSharedLibForModArg(installArgs)
    appendMapRolesToUsersArg(installArgs)
    appendPrecompileJspsArg(installArgs)
    appendUseDefaultBindingsArg(installArgs)
    appendEditionedApplicationArgs(installArgs)
    return installArgs

def updateStartingWeight():
    # if this is not an EAR deployment, the startingWeight property will not be present on the deployed
    if hasattr(deployed, 'startingWeight'):
        if deployed.isEdition and deployed.appEdition is not None:
            deployment = AdminConfig.getid('/Deployment:%s-edition%s' % (deployed.name, deployed.appEdition))
        else:
            deployment = AdminConfig.getid('/Deployment:%s' % (deployed.name))
        deployedObject = AdminConfig.showAttribute(deployment, 'deployedObject')
        AdminConfig.modify(deployedObject, [['startingWeight', str(deployed.startingWeight)]])

def deployApplication():
    installArgs = prepareInstallArgs()
    print "Deploying application", deployed.name, "with args: %s" % (installArgs)
    AdminApp.install(deployed.file, installArgs)
    updateStartingWeight()

def getApplicationEditionName(deployed):
    appName = deployed.name
    if deployed.isEdition and deployed.appEdition is not None:
        appName = "%s-edition%s" % (appName, deployed.appEdition)
    return appName
