#

def stopApplication(appName, cellName, serverName, nodeName):
    appMgrName = "cell=%s,node=%s,type=ApplicationManager,process=%s,*" % (cellName, nodeName, serverName)
    appMgr = AdminControl.queryNames(appMgrName)
    AdminControl.invoke(appMgr, 'stopApplication', '["' + appName + '"]')

def stopApplicationOnCluster():
    if not isClusterRunning(deployed.container.name):
        print "Cluster is not running therefore application is already stopped."
        sys.exit(0)

    clusterId = AdminConfig.getid("/ServerCluster:%s/" % deployed.container.name)
    clusterMembers = wsadminToList(AdminConfig.list("ClusterMember", clusterId))
    for server in clusterMembers:
        serverName = AdminConfig.showAttribute(server,"memberName")
        serverObjectName = AdminControl.completeObjectName('WebSphere:type=Server,name=%s,*' % serverName)
        if serverObjectName is None or serverObjectName == "":
            print "Server %s is not running therefore application is already stopped." % serverName
            continue

        serverNodeName = AdminControl.getAttribute(serverObjectName, 'nodeName')
        if isApplicationRunningOnServer(deployed.name, serverName, serverNodeName):
            print "Stopping application", deployed.name, "on", serverName
            stopApplication(appEditionName, deployed.container.cellName, serverName, serverNodeName)
        else:
            print "Application", deployed.name, "on", serverName, "already stopped."

def stopApplicationOnServer():
    if not isServerRunning(deployed.container.name):
        print "Server is not running therefore application is already stopped."
        sys.exit(0)
    if isApplicationRunningOnServer(deployed.name, deployed.container.name, deployed.container.nodeName):
        print "Stopping application", deployed.name, "on", deployed.container.name
        stopApplication(appEditionName, deployed.container.cellName, deployed.container.name, deployed.container.nodeName)
    else:
        print "Application", deployed.name, "on", deployed.container.name, "already stopped."


appEditionName = getApplicationEditionName(deployed)
if (deployed.container.wasTargetType == "cluster"):
    stopApplicationOnCluster()
else:
    stopApplicationOnServer()
