
def findDataSourceId(deployed):
    dataSourcesList = wsadminToList(AdminConfig.list('DataSource', AdminConfig.getid(deployed.container.containmentPath)))
    dataSourceIdList = [ds for ds in dataSourcesList if AdminConfig.showAttribute(ds, 'name') == deployed.name]
    if dataSourceIdList:
        return dataSourceIdList[0]
    return None

def configureDataSourceConnectionPool(deployed, dataSourceId):
    if hasattr(deployed, 'ConnectionPool'):
        poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties(True))
        print "Configuring Connection Pool with the arguments %s" % (poolArgs)
        AdminConfig.create('ConnectionPool', dataSourceId, poolArgs, 'connectionPool')

def generateDefaultAliasName(deployedName, container):
    return container.shortTypeDescription + '_' + container.name + '_' + deployedName + '_user'

def createOrModifyJaasAuthenticationData(deployed):
    if deployed.jaasAliasName:
        if deployed.username or deployed.password:
            printErrorAndExit("ERROR: Specify or a jaasAliasName or a username and password.")
        if not findJaasAuthenticationData(deployed.jaasAliasName, deployed.container.cellName):
            printErrorAndExit("ERROR: Cannot locate JAAS/J2C authentication data with the alias '%s'" % deployed.jaasAliasName)
    else:
        if not deployed.username:
            printErrorAndExit("ERROR: Missing username. Specify or a jaasAliasName or a username and password.")
        if not deployed.password:
            printErrorAndExit("ERROR: Missing password. Specify or a jaasAliasName or a username and password.")

    jaasAliasName = generateDefaultAliasName(deployed.name, deployed.container)
    if deployed.jaasAliasName:
        # remove ds managed alias when switching to specified alias
        if destroyJaasAuthenticationData(jaasAliasName, deployed.container.cellName):
            print "Removed DataSource managed JAAS/J2C authentication data '%s'" % jaasAliasName
        jaasAliasName = deployed.jaasAliasName
    else:
        jaasAliasId = findJaasAuthenticationData(jaasAliasName, deployed.container.cellName)
        if jaasAliasId:
            print "Updating JAAS/J2C authentication data '%s'" % (jaasAliasName)
            AdminConfig.modify(jaasAliasId, [['userId', deployed.username], ['password', deployed.password]])
        else:
            print "Creating JAAS/J2C authentication data '%s'" % (jaasAliasName)
            securityId = AdminConfig.getid("/Cell:%s/Security:/" % deployed.container.cellName)
            AdminConfig.create('JAASAuthData', securityId, [['alias', jaasAliasName], ['userId', deployed.username], ['password', deployed.password]])

    return jaasAliasName

def createOrModifyMappingModule(deployed, dataSourceId, jaasAliasName):
    mappingArgs = [
        ['authDataAlias', mapToEmptyList(jaasAliasName, deployed.useJaasAliasForContainerManagedAuthentication)],
        ['mappingConfigAlias', mapToEmptyList(deployed.mappingConfigAlias)]
    ]
    mapping = AdminConfig.showAttribute(dataSourceId, 'mapping')
    if mapping:
        print "Modifying MappingModule with the args '%s'" % (mappingArgs)
        AdminConfig.modify(mapping, mappingArgs)
    else:
        print "Creating MappingModule with the args '%s'" % (mappingArgs)
        AdminConfig.create('MappingModule', dataSourceId, mappingArgs)

def findCmpConnectorFactory(deployed, dataSourceId):
    dsName = AdminConfig.showAttribute(dataSourceId, 'name')
    cmpCfList = wsadminToList(AdminConfig.list('CMPConnectorFactory', AdminConfig.getid(deployed.container.containmentPath)))
    cmpCf = [cmp for cmp in cmpCfList if AdminConfig.showAttribute(cmp, 'name') == "%s_CF" % dsName]
    if cmpCf:
        return cmpCf[0]
    return None

def createCmpConnectorFactory(deployed, dataSourceId):
    rraId =  AdminConfig.getid('%s/J2CResourceAdapter/WebSphere Relational Resource Adapter' % deployed.container.containmentPath)
    attrs = [["name", "%s_CF" % deployed.name], ["cmpDatasource", dataSourceId]]
    print "Creating 'CMPConnectorFactory' for the datasource '%s'" % deployed.name
    AdminConfig.create("CMPConnectorFactory", rraId, attrs)

def removeCmpConnectorFactory(deployed, dataSourceId):
    cmpCfId = findCmpConnectorFactory(deployed, dataSourceId)
    if cmpCfId:
        print "Removing the 'CMPConnectorFactory' for the datasource '%s'" % deployed.name
        AdminConfig.remove(cmpCfId)
